# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate area of polynomial
#'
#' @param poly - matrix describing polynomial
#' @return W - area of polynomial
#' @export
areapl <- function(poly) {
    .Call('_stpphawkes_areapl', PACKAGE = 'stpphawkes', poly)
}

condInt_mcmc_stpp <- function(data, t_maxi, mu_init, a_init, b_init, sig_init, poly, sig_mui, sig_ai, sig_bi, sig_sigi, n_mcmc, n_burn, print) {
    .Call('_stpphawkes_condInt_mcmc_stpp', PACKAGE = 'stpphawkes', data, t_maxi, mu_init, a_init, b_init, sig_init, poly, sig_mui, sig_ai, sig_bi, sig_sigi, n_mcmc, n_burn, print)
}

condInt_mcmc_stpp_branching <- function(data, t_maxi, y_init, mu_init, a_init, b_init, sig_init, poly, mu_parami, a_parami, sig_parami, b_parami, sig_bi, sig_sigi, n_mcmc, n_burn, print) {
    .Call('_stpphawkes_condInt_mcmc_stpp_branching', PACKAGE = 'stpphawkes', data, t_maxi, y_init, mu_init, a_init, b_init, sig_init, poly, mu_parami, a_parami, sig_parami, b_parami, sig_bi, sig_sigi, n_mcmc, n_burn, print)
}

condInt_mcmc_stpp_branching_md <- function(data, t_misi, t_maxi, y_init, mu_init, a_init, b_init, sig_init, poly, mu_parami, a_parami, sig_parami, b_parami, sig_bi, sig_sigi, n_mcmc, n_burn, print, sp_clip) {
    .Call('_stpphawkes_condInt_mcmc_stpp_branching_md', PACKAGE = 'stpphawkes', data, t_misi, t_maxi, y_init, mu_init, a_init, b_init, sig_init, poly, mu_parami, a_parami, sig_parami, b_parami, sig_bi, sig_sigi, n_mcmc, n_burn, print, sp_clip)
}

condInt_mcmc_stpp_branching_nonunif <- function(data, t_maxi, y_init, mu_init, a_init, b_init, sig_init, mux_init, muy_init, sigx_init, sigy_init, poly, mu_parami, a_parami, sig_parami, b_parami, sig_bi, sig_sigi, mux_parami, muy_parami, sigx_parami, sigy_parami, n_mcmc, n_burn, print) {
    .Call('_stpphawkes_condInt_mcmc_stpp_branching_nonunif', PACKAGE = 'stpphawkes', data, t_maxi, y_init, mu_init, a_init, b_init, sig_init, mux_init, muy_init, sigx_init, sigy_init, poly, mu_parami, a_parami, sig_parami, b_parami, sig_bi, sig_sigi, mux_parami, muy_parami, sigx_parami, sigy_parami, n_mcmc, n_burn, print)
}

condInt_mcmc_stpp_branching_nonunif_md <- function(data, t_misi, t_maxi, y_init, mu_init, a_init, b_init, sig_init, mux_init, muy_init, sigx_init, sigy_init, poly, mu_parami, a_parami, sig_parami, b_parami, sig_bi, sig_sigi, mux_parami, muy_parami, sigx_parami, sigy_parami, n_mcmc, n_burn, print, sp_clip) {
    .Call('_stpphawkes_condInt_mcmc_stpp_branching_nonunif_md', PACKAGE = 'stpphawkes', data, t_misi, t_maxi, y_init, mu_init, a_init, b_init, sig_init, mux_init, muy_init, sigx_init, sigy_init, poly, mu_parami, a_parami, sig_parami, b_parami, sig_bi, sig_sigi, mux_parami, muy_parami, sigx_parami, sigy_parami, n_mcmc, n_burn, print, sp_clip)
}

condInt_mcmc_temporal <- function(ti, t_maxi, mu_init, alpha_init, beta_init, sig_mui, sig_alphai, sig_betai, n_mcmc, n_burn, print) {
    .Call('_stpphawkes_condInt_mcmc_temporal', PACKAGE = 'stpphawkes', ti, t_maxi, mu_init, alpha_init, beta_init, sig_mui, sig_alphai, sig_betai, n_mcmc, n_burn, print)
}

condInt_mcmc_temporal_branching <- function(ti, t_maxi, y_init, mu_init, alpha_init, beta_init, mu_parami, alpha_parami, beta_parami, sig_betai, n_mcmc, n_burn, print) {
    .Call('_stpphawkes_condInt_mcmc_temporal_branching', PACKAGE = 'stpphawkes', ti, t_maxi, y_init, mu_init, alpha_init, beta_init, mu_parami, alpha_parami, beta_parami, sig_betai, n_mcmc, n_burn, print)
}

condInt_mcmc_temporal_branching_md <- function(ti, t_misi, t_maxi, y_init, mu_init, alpha_init, beta_init, mu_parami, alpha_parami, beta_parami, sig_betai, n_mcmc, n_burn, print) {
    .Call('_stpphawkes_condInt_mcmc_temporal_branching_md', PACKAGE = 'stpphawkes', ti, t_misi, t_maxi, y_init, mu_init, alpha_init, beta_init, mu_parami, alpha_parami, beta_parami, sig_betai, n_mcmc, n_burn, print)
}

condInt_mcmc_temporal_md <- function(ti, t_misi, t_maxi, mu_init, alpha_init, beta_init, sig_mui, sig_alphai, sig_betai, n_mcmc, n_burn, print, printmc) {
    .Call('_stpphawkes_condInt_mcmc_temporal_md', PACKAGE = 'stpphawkes', ti, t_misi, t_maxi, mu_init, alpha_init, beta_init, sig_mui, sig_alphai, sig_betai, n_mcmc, n_burn, print, printmc)
}

temporal_likelihood <- function(t, mu, alpha, beta, t_max) {
    .Call('_stpphawkes_temporal_likelihood', PACKAGE = 'stpphawkes', t, mu, alpha, beta, t_max)
}

stpp_likelihood <- function(x, y, t, poly, mu, a, b, sig, t_max) {
    .Call('_stpphawkes_stpp_likelihood', PACKAGE = 'stpphawkes', x, y, t, poly, mu, a, b, sig, t_max)
}

stpp_likelihood_nonunif <- function(x, y, t, mu, a, b, sig, mux, muy, sigx, sigy, t_max) {
    .Call('_stpphawkes_stpp_likelihood_nonunif', PACKAGE = 'stpphawkes', x, y, t, mu, a, b, sig, mux, muy, sigx, sigy, t_max)
}

bbox <- function(poly) {
    .Call('_stpphawkes_bbox', PACKAGE = 'stpphawkes', poly)
}

bboxx <- function(poly) {
    .Call('_stpphawkes_bboxx', PACKAGE = 'stpphawkes', poly)
}

sbox <- function(poly, xfrac, yfrac) {
    .Call('_stpphawkes_sbox', PACKAGE = 'stpphawkes', poly, xfrac, yfrac)
}

buffer_region <- function(poly, d) {
    .Call('_stpphawkes_buffer_region', PACKAGE = 'stpphawkes', poly, d)
}

larger_region <- function(poly, xfrac, yfrac) {
    .Call('_stpphawkes_larger_region', PACKAGE = 'stpphawkes', poly, xfrac, yfrac)
}

inout <- function(x, y, poly, bound) {
    .Call('_stpphawkes_inout', PACKAGE = 'stpphawkes', x, y, poly, bound)
}

#' Calculate if points are in the polynomial
#'
#' @param x - vector of x coordinates
#' @param y - vector of y coordinates
#' @param xp - vector of x coordinates of polynomial
#' @param yp - vector of y coordinates of polynomial
#' @param bb - matrix of bounding box of polynomial
#' @return inout - vector of 1 if point is in polynomial and 0 if not
#' @export
ptinpoly <- function(x, y, xp, yp, bb) {
    .Call('_stpphawkes_ptinpoly', PACKAGE = 'stpphawkes', x, y, xp, yp, bb)
}

#' Simulate homogenous spatio-temporal hawkes model
#'
#' @param params - list containing params (\eqn{\mu}, \eqn{a}, \eqn{b}, \eqn{\sigma})
#' @param poly - matrix defining polygon (\eqn{N} x \eqn{2})
#' @param t_region - vector of two elements describing time region (e.g., c(0,10))
#' @param d - generate parents on larger polygon by expanded observed polygon by d (default = R::qnorm(.95, 0, sig, 1, 0))
#' @param history - history of process (e.g., numeric())
#' @param seed - set random number seed (default=-1)
#' @return A DataFrame containing \eqn{x},\eqn{y},\eqn{t}
#' @export
simulate_hawkes_stpp <- function(params, poly, t_region, d, history, seed = -1L) {
    .Call('_stpphawkes_simulate_hawkes_stpp', PACKAGE = 'stpphawkes', params, poly, t_region, d, history, seed)
}

#' Simulate inhomogenous spatio-temporal hawkes model
#'
#' @param params - list containing params (\eqn{\mu}, \eqn{a}, \eqn{b}, \eqn{\sigma},\eqn{\mu x}, \eqn{\mu y}, \eqn{\sigma x}, \eqn{\sigma y} )
#' @param poly - matrix defining polygon (\eqn{N} x \eqn{2})
#' @param t_region - vector of two elements describing time region (e.g., c(0,10))
#' @param d - generate parents on larger polygon by expanded observed polygon by d (default = R::qnorm(.95, 0, sig, 1, 0))
#' @param history - history of process (e.g., numeric())
#' @param seed - set random number seed (default=-1)
#' @return A DataFrame containing \eqn{x},\eqn{y},\eqn{t}
#' @export
simulate_hawkes_stpp_nonunif <- function(params, poly, t_region, d, history, seed = -1L) {
    .Call('_stpphawkes_simulate_hawkes_stpp_nonunif', PACKAGE = 'stpphawkes', params, poly, t_region, d, history, seed)
}

#' Calculate intensity function for temporal Hawkes
#'
#' @param mu - background parameter
#' @param alpha - alpha parameter
#' @param beta - beta parameter
#' @param times - history of previous times
#' @param evalpt - point to evaluate
#' @return lambda - intensity at evalpt
#' @export
intensity_temporal <- function(mu, alpha, beta, times, evalpt) {
    .Call('_stpphawkes_intensity_temporal', PACKAGE = 'stpphawkes', mu, alpha, beta, times, evalpt)
}

#' Simulates a temporal Hawkes process with an exponential correlation function
#'
#' @param mu - background parameter
#' @param alpha - \eqn{\alpha} parameter
#' @param beta - \eqn{\beta} parameter
#' @param tt - vector of two elements defining time span (e.g., c(0,10))
#' @param times - history of previous times (e.g., numeric())
#' @param seed - value to seed random number generation (default = -1)
#' @return arrivals - vector of arrival times
#' @export
#' @examples 
#'     times = simulate_temporal(.5,.1,.5,c(0,10),numeric())
simulate_temporal <- function(mu, alpha, beta, tt, times, seed = -1L) {
    .Call('_stpphawkes_simulate_temporal', PACKAGE = 'stpphawkes', mu, alpha, beta, tt, times, seed)
}

CatMarkMcMc <- function(t, t_max, marks, mu_init, alpha_init, beta_init, mu_params, alpha_param, beta_param, p_param, sig_beta, n_mcmc = 1e4L, n_burn = 5e3L, print = 1L) {
    .Call('_stpphawkes_CatMarkMcMc', PACKAGE = 'stpphawkes', t, t_max, marks, mu_init, alpha_init, beta_init, mu_params, alpha_param, beta_param, p_param, sig_beta, n_mcmc, n_burn, print)
}

CatMarkMcMcMissingData <- function(t, t_missing, t_max, marks, mu_init, alpha_init, beta_init, p_init, mu_params, alpha_params, beta_params, p_params, sig_beta, n_mcmc = 1e4L, n_burn = 5e3L, print = 1L) {
    .Call('_stpphawkes_CatMarkMcMcMissingData', PACKAGE = 'stpphawkes', t, t_missing, t_max, marks, mu_init, alpha_init, beta_init, p_init, mu_params, alpha_params, beta_params, p_params, sig_beta, n_mcmc, n_burn, print)
}

WeibullMarkMcMc <- function(t, t_max, marks, wshape, mu_init, alpha_init, beta_init, wscale_init, mu_params, alpha_param, beta_param, wscale_param, sig_beta, n_mcmc = 1e4L, n_burn = 5e3L, print = 1L) {
    .Call('_stpphawkes_WeibullMarkMcMc', PACKAGE = 'stpphawkes', t, t_max, marks, wshape, mu_init, alpha_init, beta_init, wscale_init, mu_params, alpha_param, beta_param, wscale_param, sig_beta, n_mcmc, n_burn, print)
}

