% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.rownames}
\alias{is.rownames}
\title{Test for `rownames`}
\usage{
is.rownames(nm, x)
}
\arguments{
\item{nm}{character vector.}

\item{x}{object whose rownames are desired to be tested.}
}
\value{
TRUE for every element of `nm` that is a rowname of x and FALSE otherwise.
The structure is a logical vector with length = length(`nm`) and names = `nm`.
See details for special cases.
}
\description{
\code{is.rownames} returns whether elements of a character vector are rownames of an object.
}
\details{
If the object does not have any rownames, then the function will return `FALSE`
for each element of the character vector.
}
\examples{
data("mtcars")
is.rownames(x = as.matrix(mtcars), nm = c("Mazda RX4","mazda RX4"))
}
