% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifiedyh.R
\name{custom_transform}
\alias{custom_transform}
\title{Apply Custom Transformation to Data Column}
\usage{
custom_transform(df, selected_column, transformation_type)
}
\arguments{
\item{df}{A data frame containing the data.}

\item{selected_column}{A character string specifying the column to be transformed.}

\item{transformation_type}{A character string representing the transformation type: "scale", "normalize", "log", or a custom R function.}
}
\value{
A data frame with the transformed column.
}
\description{
This function allows the user to apply a custom transformation (scaling, normalization, log transform, or custom function) to a specified numeric column.
}
\examples{
result <- custom_transform(iris, selected_column = "Sepal.Length", transformation_type = "scale")
}
