/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.MultiChoiceOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Stack;
import moa.classifiers.Regressor;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.FIMTDDNumericAttributeClassObserver;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.classifiers.trees.FIMTDD;
import moa.core.AutoExpandVector;
import moa.core.Measurement;

public class ORTO
extends FIMTDD
implements Regressor {
    private static final long serialVersionUID = 1L;
    private int innerNodeCount = 0;
    private int optionNodeCount = 0;
    private int numTrees = 1;
    public IntOption maxTreesOption = new IntOption("maxTrees", 'm', "The maximum number of trees contained in the option tree.", 10, 1, Integer.MAX_VALUE);
    public IntOption maxOptionLevelOption = new IntOption("maxOptionLevel", 'x', "The maximal depth at which option nodes can be created.", 10, 0, Integer.MAX_VALUE);
    public FloatOption optionDecayFactorOption = new FloatOption("optionDecayFactor", 'z', "The option decay factor that determines how many options can be selected at a given level.", 0.9, 0.0, 1.0);
    public MultiChoiceOption optionNodeAggregationOption = new MultiChoiceOption("optionNodeAggregation", 'o', "The aggregation method used to combine predictions in option nodes.", new String[]{"average", "bestTree"}, new String[]{"Average", "Best tree"}, 0);
    public FloatOption optionFadingFactorOption = new FloatOption("optionFadingFactor", 'q', "The fading factor used for comparing subtrees of an option node.", 0.9995, 0.0, 1.0);

    @Override
    public String getPurposeString() {
        return "Implementation of the ORTO tree as described by Ikonomovska et al.";
    }

    @Override
    public void resetLearningImpl() {
        super.resetLearningImpl();
        this.innerNodeCount = 0;
        this.optionNodeCount = 0;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("number of subtrees", this.numTrees), new Measurement("tree size (nodes)", this.leafNodeCount + this.innerNodeCount), new Measurement("tree size (leaves)", this.leafNodeCount), new Measurement("number of option nodes", this.optionNodeCount)};
    }

    @Override
    public void processInstance(Instance inst, FIMTDD.Node node, double prediction, double normalError, boolean growthAllowed, boolean inAlternate) {
        block20: {
            if (node instanceof OptionNode) {
                this.processInstanceOptionNode(inst, (OptionNode)node, prediction, normalError, growthAllowed, inAlternate);
            } else {
                FIMTDD.Node currentNode = node;
                while (true) {
                    if (currentNode instanceof FIMTDD.LeafNode) {
                        ((FIMTDD.LeafNode)currentNode).learnFromInstance(inst, growthAllowed);
                        break block20;
                    }
                    currentNode.examplesSeen += inst.weight();
                    currentNode.sumOfAbsErrors += inst.weight() * normalError;
                    FIMTDD.InnerNode iNode = (FIMTDD.InnerNode)currentNode;
                    if (!inAlternate && iNode.alternateTree != null) {
                        boolean altTree = true;
                        double lossO = Math.pow(inst.classValue() - prediction, 2.0);
                        double lossA = Math.pow(inst.classValue() - currentNode.alternateTree.getPrediction(inst), 2.0);
                        int i = 0;
                        while ((double)i < inst.weight()) {
                            iNode.lossFadedSumOriginal = lossO + this.alternateTreeFadingFactorOption.getValue() * iNode.lossFadedSumOriginal;
                            iNode.lossFadedSumAlternate = lossA + this.alternateTreeFadingFactorOption.getValue() * iNode.lossFadedSumAlternate;
                            iNode.lossExamplesSeen += 1.0;
                            double Qi = Math.log(iNode.lossFadedSumOriginal / iNode.lossFadedSumAlternate);
                            iNode.lossSumQi += Qi;
                            iNode.lossNumQiTests += 1.0;
                            ++i;
                        }
                        double Qi = Math.log(iNode.lossFadedSumOriginal / iNode.lossFadedSumAlternate);
                        double previousQiAverage = iNode.lossSumQi / iNode.lossNumQiTests;
                        double QiAverage = iNode.lossSumQi / iNode.lossNumQiTests;
                        if (iNode.lossExamplesSeen - iNode.previousWeight >= (double)this.alternateTreeTMinOption.getValue()) {
                            iNode.previousWeight = iNode.lossExamplesSeen;
                            if (Qi > 0.0) {
                                FIMTDD.Node parent = currentNode.parent;
                                if (parent != null) {
                                    FIMTDD.Node replacementTree = iNode.alternateTree;
                                    parent.setChild(parent.getChildIndex(iNode), replacementTree);
                                    if (growthAllowed) {
                                        replacementTree.restartChangeDetection();
                                    }
                                } else {
                                    this.treeRoot = iNode.alternateTree;
                                    this.treeRoot.restartChangeDetection();
                                }
                                this.optionNodeCount += currentNode.alternateTree.getNumSubtrees() - currentNode.getNumSubtrees();
                                this.removeExcessTrees();
                                currentNode = iNode.alternateTree;
                                currentNode.originalNode = null;
                                altTree = false;
                            } else if (QiAverage < previousQiAverage && iNode.lossExamplesSeen >= (double)(10 * this.alternateTreeTMinOption.getValue()) || iNode.lossExamplesSeen >= (double)this.alternateTreeTimeOption.getValue()) {
                                iNode.alternateTree = null;
                                if (growthAllowed) {
                                    iNode.restartChangeDetection();
                                }
                                altTree = false;
                            }
                        }
                        if (altTree) {
                            growthAllowed = false;
                            this.processInstance(inst, currentNode.alternateTree, prediction, normalError, true, true);
                        } else if (currentNode instanceof OptionNode) {
                            for (FIMTDD.Node child : ((OptionNode)currentNode).children) {
                                this.processInstance(inst, child, child.getPrediction(inst), normalError, growthAllowed, inAlternate);
                            }
                            break block20;
                        }
                    }
                    if (iNode.changeDetection && !inAlternate && iNode.PageHinckleyTest(normalError - iNode.sumOfAbsErrors / iNode.examplesSeen - this.PageHinckleyAlphaOption.getValue(), this.PageHinckleyThresholdOption.getValue())) {
                        iNode.initializeAlternateTree();
                    }
                    if (currentNode instanceof FIMTDD.SplitNode) {
                        currentNode = ((FIMTDD.SplitNode)currentNode).descendOneStep(inst);
                        continue;
                    }
                    if (currentNode instanceof OptionNode) break;
                }
                this.processInstanceOptionNode(inst, (OptionNode)currentNode, prediction, normalError, growthAllowed, inAlternate);
            }
        }
    }

    public void processInstanceOptionNode(Instance inst, OptionNode node, double prediction, double normalError, boolean growthAllowed, boolean inAlternate) {
        if (node.changeDetection) {
            double error = Math.abs(prediction - inst.classValue());
            node.sumOfAbsErrors += error;
            if (node.PageHinckleyTest(error - node.sumOfAbsErrors / node.examplesSeen + this.PageHinckleyAlphaOption.getValue(), this.PageHinckleyThresholdOption.getValue())) {
                node.initializeAlternateTree();
            }
        }
        for (FIMTDD.Node child : node.children) {
            int index = node.getChildIndex(child);
            double childPrediction = child.getPrediction(inst);
            int i = 0;
            while ((double)i < inst.weight()) {
                node.optionFFSeen[index] = node.optionFFSeen[index] * this.optionFadingFactorOption.getValue() + 1.0;
                node.optionFFSSL[index] = node.optionFFSSL[index] * this.optionFadingFactorOption.getValue() + Math.pow(childPrediction - inst.classValue(), 2.0);
                ++i;
            }
        }
        for (FIMTDD.Node child : node.children) {
            this.processInstance(inst, child, child.getPrediction(inst), normalError, growthAllowed && node.alternateTree == null, inAlternate);
        }
    }

    protected OptionNode newOptionNode() {
        ++this.maxID;
        return new OptionNode(this);
    }

    @Override
    protected void attemptToSplit(FIMTDD.LeafNode node, FIMTDD.Node parent, int parentIndex) {
        SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
        Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion);
        LinkedList<Object> acceptedSplits = new LinkedList<Object>();
        Arrays.sort(bestSplitSuggestions);
        int numSplits = 0;
        if (bestSplitSuggestions.length == 1) {
            numSplits = 1;
            acceptedSplits.add(bestSplitSuggestions[0]);
        } else if (bestSplitSuggestions.length > 1) {
            double hoeffdingBound = ORTO.computeHoeffdingBound(1.0, this.splitConfidenceOption.getValue(), node.examplesSeen);
            Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
            if (((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit < 1.0 - hoeffdingBound) {
                numSplits = 1;
                acceptedSplits.add(bestSuggestion);
            } else if (this.numTrees < this.maxTreesOption.getValue() && node.getLevel() <= this.maxOptionLevelOption.getValue()) {
                for (Object suggestion : bestSplitSuggestions) {
                    if (!(((AttributeSplitSuggestion)suggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit >= 1.0 - hoeffdingBound)) continue;
                    ++numSplits;
                    acceptedSplits.add(suggestion);
                }
            } else if (hoeffdingBound < this.tieThresholdOption.getValue()) {
                numSplits = 1;
                acceptedSplits.add(bestSplitSuggestions[0]);
            } else {
                for (int i = 0; i < node.attributeObservers.size(); ++i) {
                    AttributeClassObserver attributeClassObserver = node.attributeObservers.get(i);
                    if (attributeClassObserver == null) continue;
                    ((FIMTDDNumericAttributeClassObserver)attributeClassObserver).removeBadSplits(splitCriterion, ((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit, ((AttributeSplitSuggestion)bestSuggestion).merit, hoeffdingBound);
                }
            }
        }
        if (numSplits > 0) {
            double optionFactor = (double)numSplits * Math.pow(this.optionDecayFactorOption.getValue(), node.getLevel());
            if (numSplits == 1 || optionFactor < 2.0 || this.maxTreesOption.getValue() - this.numTrees <= 1) {
                AttributeSplitSuggestion splitDecision = (AttributeSplitSuggestion)acceptedSplits.get(0);
                FIMTDD.SplitNode newSplit = this.newSplitNode(splitDecision.splitTest);
                for (int i = 0; i < splitDecision.numSplits(); ++i) {
                    FIMTDD.LeafNode leafNode = this.newLeafNode();
                    leafNode.setParent(newSplit);
                    newSplit.setChild(i, leafNode);
                }
                --this.leafNodeCount;
                ++this.innerNodeCount;
                this.leafNodeCount += splitDecision.numSplits();
                if (parent == null) {
                    this.treeRoot = newSplit;
                } else {
                    parent.setChild(parent.getChildIndex(node), newSplit);
                    newSplit.setParent(parent);
                }
            } else {
                OptionNode optionNode = this.newOptionNode();
                --this.leafNodeCount;
                int j = 0;
                for (AttributeSplitSuggestion attributeSplitSuggestion : acceptedSplits) {
                    if ((double)j > optionFactor || this.maxTreesOption.getValue() - this.numTrees <= 0) break;
                    FIMTDD.SplitNode newSplit = this.newSplitNode(attributeSplitSuggestion.splitTest);
                    for (int i = 0; i < attributeSplitSuggestion.numSplits(); ++i) {
                        FIMTDD.LeafNode newChild = this.newLeafNode();
                        newChild.setParent(newSplit);
                        newSplit.setChild(i, newChild);
                    }
                    this.leafNodeCount += attributeSplitSuggestion.numSplits();
                    ++this.innerNodeCount;
                    ++this.numTrees;
                    newSplit.setParent(optionNode);
                    optionNode.setChild(j, newSplit);
                    ++j;
                }
                ++this.innerNodeCount;
                ++this.optionNodeCount;
                if (parent == null) {
                    this.treeRoot = optionNode;
                } else {
                    parent.setChild(parent.getChildIndex(node), optionNode);
                    optionNode.setParent(parent);
                }
                optionNode.resetFF();
            }
        }
    }

    protected FIMTDD.Node findWorstOption() {
        Stack<FIMTDD.Node> stack = new Stack<FIMTDD.Node>();
        stack.add(this.treeRoot);
        double ratio = Double.MIN_VALUE;
        FIMTDD.Node out = null;
        while (!stack.empty()) {
            int nodeIndex;
            OptionNode myParent;
            double nodeRatio;
            FIMTDD.Node node = (FIMTDD.Node)stack.pop();
            if (node.getParent() instanceof OptionNode && (nodeRatio = (myParent = (OptionNode)node.getParent()).getFFRatio(nodeIndex = myParent.getChildIndex(node))) > ratio) {
                ratio = nodeRatio;
                out = node;
            }
            if (!(node instanceof FIMTDD.InnerNode)) continue;
            for (FIMTDD.Node child : ((FIMTDD.InnerNode)node).children) {
                stack.add(child);
            }
        }
        return out;
    }

    protected void removeExcessTrees() {
        while (this.numTrees > this.maxTreesOption.getValue()) {
            FIMTDD.Node option = this.findWorstOption();
            OptionNode parent = (OptionNode)option.parent;
            int index = parent.getChildIndex(option);
            if (parent.children.size() == 2) {
                parent.children.remove(index);
                for (FIMTDD.Node chld : parent.children) {
                    chld.parent = parent.parent;
                    parent.parent.setChild(parent.parent.getChildIndex(parent), chld);
                }
            } else {
                AutoExpandVector<FIMTDD.Node> children = new AutoExpandVector<FIMTDD.Node>();
                double[] optionFFSSL = new double[parent.children.size() - 1];
                double[] optionFFSeen = new double[parent.children.size() - 1];
                int seen = 0;
                for (int i = 0; i < parent.children.size() - 1; ++i) {
                    if (parent.getChild(i) != option) {
                        children.add(parent.getChild(i));
                        optionFFSSL[i] = parent.optionFFSSL[i + seen];
                        optionFFSeen[i] = parent.optionFFSeen[i + seen];
                        continue;
                    }
                    seen = 1;
                }
                parent.children = children;
                parent.optionFFSSL = optionFFSSL;
                parent.optionFFSeen = optionFFSeen;
                assert (parent.children.size() == parent.optionFFSSL.length);
            }
            --this.numTrees;
        }
    }

    public static class OptionNode
    extends FIMTDD.InnerNode {
        private static final long serialVersionUID = 1L;
        protected double[] optionFFSSL;
        protected double[] optionFFSeen;

        public OptionNode(FIMTDD tree) {
            super(tree);
        }

        public void resetFF() {
            this.optionFFSSL = new double[this.children.size()];
            this.optionFFSeen = new double[this.children.size()];
            for (int i = 0; i < this.children.size(); ++i) {
                this.optionFFSSL[i] = 0.0;
                this.optionFFSeen[i] = 0.0;
            }
        }

        @Override
        public int getNumSubtrees() {
            int num = 0;
            for (FIMTDD.Node child : this.children) {
                num += child.getNumSubtrees();
            }
            return num;
        }

        public int directionForBestTree() {
            int d = 0;
            double tmp = 0.0;
            double min = Double.MAX_VALUE;
            for (int i = 0; i < this.children.size(); ++i) {
                tmp = this.getFFRatio(i);
                if (!(tmp < min)) continue;
                min = tmp;
                d = i;
            }
            return d;
        }

        public double getPrediction(Instance inst, ORTO tree) {
            double[] predictions = new double[this.numChildren()];
            for (int i = 0; i < this.numChildren(); ++i) {
                predictions[i] = this.getChild(i).getPrediction(inst);
            }
            return this.aggregate(predictions, tree);
        }

        private double aggregate(double[] predictions, ORTO tree) {
            if (tree.optionNodeAggregationOption.getChosenIndex() == 0) {
                double sum = 0.0;
                for (int i = 0; i < predictions.length; ++i) {
                    sum += predictions[i];
                }
                return sum / (double)predictions.length;
            }
            if (tree.optionNodeAggregationOption.getChosenIndex() == 1) {
                int d = this.directionForBestTree();
                return predictions[d];
            }
            return 0.0;
        }

        public double getFFRatio(int childIndex) {
            return this.optionFFSSL[childIndex] / this.optionFFSeen[childIndex];
        }

        @Override
        protected boolean skipInLevelCount() {
            return true;
        }
    }
}

