% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/string_magic_main.R
\name{cat_magic_alias}
\alias{cat_magic_alias}
\alias{message_magic_alias}
\alias{cat_magic}
\alias{catma}
\alias{message_magic}
\alias{mema}
\title{Display messages using interpolated strings}
\usage{
cat_magic_alias(
  .sep = "",
  .end = "",
  .width = FALSE,
  .leader = "",
  .delim = c("{", "}"),
  .last = NULL,
  .trigger = TRUE,
  .check = TRUE,
  .namespace = NULL
)

message_magic_alias(
  .sep = "",
  .end = "\\n",
  .width = ~min(100, .sw),
  .leader = "",
  .delim = c("{", "}"),
  .last = NULL,
  .trigger = TRUE,
  .check = TRUE,
  .namespace = NULL
)

cat_magic(
  ...,
  .sep = "",
  .end = "",
  .width = FALSE,
  .leader = "",
  .envir = parent.frame(),
  .delim = c("{", "}"),
  .last = NULL,
  .trigger = TRUE,
  .check = TRUE,
  .help = NULL,
  .namespace = NULL
)

catma(
  ...,
  .sep = "",
  .end = "",
  .width = FALSE,
  .leader = "",
  .envir = parent.frame(),
  .delim = c("{", "}"),
  .last = NULL,
  .trigger = TRUE,
  .check = TRUE,
  .help = NULL,
  .namespace = NULL
)

message_magic(
  ...,
  .sep = "",
  .end = "\\n",
  .width = NULL,
  .leader = "",
  .envir = parent.frame(),
  .delim = c("{", "}"),
  .last = NULL,
  .trigger = TRUE,
  .check = TRUE,
  .help = NULL,
  .namespace = NULL
)

mema(
  ...,
  .sep = "",
  .end = "\\n",
  .width = NULL,
  .leader = "",
  .envir = parent.frame(),
  .delim = c("{", "}"),
  .last = NULL,
  .trigger = TRUE,
  .check = TRUE,
  .help = NULL,
  .namespace = NULL
)
}
\arguments{
\item{.sep}{Character scalar, default is the empty string \code{""}. It is used to collapse all
the elements in \code{...} before applying any operation.}

\item{.end}{Character scalar, default is \code{""} (the empty string) for \code{cat_magic},
and \code{"\\n"} (a newline) for \code{message_magic}.
This string will be collated at the end of the message (a common alternative is \code{"\\n"}).}

\item{.width}{Can be 1) a positive integer, 2) a number in (0;1), 3) \code{FALSE} (default
for \code{cat_magic}), 4) \code{NULL} (default for \code{message_magic}), or 5) a one-sided formula. It represents the target
width of the message on the user console. Newlines will be added \emph{between words} to fit the
target width.
\enumerate{
\item positive integer: number of characters
\item number (0;1): fraction of the screen
\item \code{FALSE}: does not add newlines
\item \code{NULL}: the min between 100 characters and 90\% of the screen width
\item one-sided formula: an expression in which you can use the special variable
\code{.sw} which represents the current screen width
}

Note that the value \code{NULL} is equivalent to using \code{~min(100, 0.9*.sw)}.}

\item{.leader}{Character scalar, default is \code{TRUE}. Only used if argument \code{.width} is not \code{FALSE}.
Whether to add a leading character string right after the extra new lines.}

\item{.delim}{Character vector of length 1 or 2. Default is \code{c("{", "}")}. Defines
the opening and the closing delimiters for interpolation.

If of length 1, it must be of the form: 1) the opening delimiter,
2) a single space, 3) the closing delimiter. Ex: \code{".[ ]"} is equivalent to \code{c(".[", "]")}.
The default value is equivalent to \code{"{ }"}.

[ ]: R:\%20
[", "]: R:\%22,\%20\%22}

\item{.last}{Character scalar, a function, or \code{NULL} (default). If provided and character:
it must be an \code{string_magic} chain of operations of the form \code{"'arg1'op1, op2, etc"}. All these operations
are applied just before returning the vector. If a function,
it will be applied to the resulting vector.}

\item{.trigger}{Logical, default is \code{TRUE}. If \code{FALSE}, this function is not run. Can be
useful in debugging situations where we want conditional evaluations.}

\item{.check}{Logical scalar, default is \code{TRUE}. Whether to enable error-handling (i.e.
human readable error messages).
Without error-handling you can save something of the order of 40us. Useful only
in long loops.}

\item{.namespace}{Character scalar or \code{NULL} (default). \strong{Only useful for package developers.}
As a regular end-user you shouldn't care! If your package uses \code{string_magic}, you should care.
It is useful \strong{only} if your package uses 'custom' \code{string_magic} operations, set with
\code{\link[=string_magic_register_fun]{string_magic_register_fun()}} or \code{\link[=string_magic_register_ops]{string_magic_register_ops()}}.}

\item{...}{Character scalars that will be collapsed with the argument \code{sep}. Note that
named arguments are used for substitution.

To interpolate, you can
use \code{"{x}"} within each character string to insert the value of \code{x} in the string.
You can add string operations in each \code{"{}"} instance with the syntax \code{"'arg'op ? x"}
(resp. \code{"'arg'op ! x"}) to apply the operation \code{'op'} with the argument \code{'arg'} to \code{x}
(resp. the verbatim of \code{x}). Otherwise, what to say? Ah, nesting is enabled, and since
there's over 50 operators, it's a bit complicated to sort you out in this small space.

Use the argument \code{.help = "keyword"} (or \code{.help = TRUE}) to obtain a selective help
from the main documentation.

Note that in interpolations you have access to the special variables: \code{.now} and \code{.date}
to get the current time; and the special function \code{.now("format")} to
format the time. Ex: \code{.now('\%Y-\%m \%H:\%m')}.}

\item{.envir}{An environment used to evaluate the variables in \code{"{}"}. By default the variables are
evaluated using the environment from where the function is called or using the named
arguments passed to the function.}

\item{.help}{Character scalar or \code{TRUE}, default is \code{NULL}. This argument
is used to generate a dynamic help on the console. If \code{TRUE}, the user can select which
topic to read from the main documentation, with the possibility to search for keywords and
navigate the help pages. If a character scalar, then a regex search is perfomed on the main
documentation and any section containining a match is displayed. The user can easily
navigate across matches.}
}
\value{
The functions \code{cat_magic()} and \code{message_magic()} do not return anything, they simply print on the console.

The function \code{cat_magic_alis()} returns a function behaving identically to \code{\link[=cat_magic]{cat_magic()}} but for which the
default values have been altered.
Same for \code{message_magic_alias()}.
}
\description{
Utilities to display messages using \code{string_magic} interpolation and operations to generate the message.
}
\details{
These functions are \code{\link[base:cat]{base::cat()}}/\code{\link[=message]{message()}} wrappers aroung \code{\link[=string_magic]{string_magic()}}. There is one notable difference
with respect to \code{cat}/\code{message}. It's the ability to add newlines after words for
the message to fit a target width. This is controlled with the argument \code{.width}. This is
active by default for \code{message_magic} (default is \code{.width = NULL} which leads to the
minimum betwen 100 characters and 90\% of the screen width).

You can very easily change the default values with the alias generators \code{cat_magic_alias} and
\code{message_magic_alias}.

\verb{[Advanced]} A note for package developers who would use these functions \strong{and}
also use custom \code{string_magic} operations created with \code{\link[=string_magic_register_fun]{string_magic_register_fun()}} or
\code{\link[=string_magic_register_ops]{string_magic_register_ops()}}. To ensure forward compatibility the new operations created
should be defined in the package namespace (see the \emph{ad hoc} section in \code{\link[=string_magic_register_fun]{string_magic_register_fun()}} help).
To access these operators in their specific namespaces, you must use an alias with
\code{cat_magic_alias} or \code{message_magic_alias} with the argument \code{.namespace = "myPackageName"}
(to avoid having to provide the \code{.namespace} argument repeatedly).
}
\section{Functions}{
\itemize{
\item \code{cat_magic_alias()}: Create an alias of \code{cat_magic} with custom defaults

\item \code{message_magic_alias()}: Create an alias of \code{message_magic} with custom defaults

\item \code{catma()}: Alias to \code{cat_magic}

\item \code{message_magic()}: Display messages using interpolated strings

\item \code{mema()}: Alias to \code{message_magic}

}}
\examples{

start = Sys.time()
Sys.sleep(0.05)
message_magic("This example has run in {difftime ? start}.")

cat_magic("Let's write a very long message to illustrate how .width work.", 
          .width = 40)

# Let's add a leader
cat_magic("Let's write a very long message to illustrate how `.width` work.", 
          "And now we add `.leader`.", .width = 40, .leader = "#> ")

# newlines respect the introductory spaces
cat_magic("Here's a list:", 
          "    + short item", 
          "    + this is a very long item that likely overflows", 
         .width = 30, .sep = "\n")


}
\seealso{
Other tools with aliases: 
\code{\link{string_clean_alias}()},
\code{\link{string_magic}()},
\code{\link{string_magic_alias}()},
\code{\link{string_ops_alias}()},
\code{\link{string_vec_alias}()}
}
\concept{tools with aliases}
