% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casefold.R
\name{strs_casefold}
\alias{strs_casefold}
\title{Perform case folding on strings}
\usage{
strs_casefold(string)
}
\arguments{
\item{string}{A character vector where each element is a string to be
case-folded.}
}
\value{
A character vector of the same length as \code{string}, where each element
has been case-folded.
}
\description{
\code{strs_casefold} is used to perform case folding on each element of a
character vector. This function is particularly useful for case-insensitive
string matching and is similar to Python's \code{str.casefold()} method.
}
\examples{
strs_casefold("HELLO World")
strs_casefold("Äpfel")
}
\seealso{
\href{https://docs.python.org/3/library/stdtypes.html#str.casefold}{Python str.casefold() documentation}
}
