% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest2_predict.R
\name{stylest2_predict}
\alias{stylest2_predict}
\title{Predict authorship of texts.}
\usage{
stylest2_predict(
  dfm,
  model,
  speaker_odds = FALSE,
  term_influence = FALSE,
  prior = NULL
)
}
\arguments{
\item{dfm}{a quanteda \code{dfm} object. Each row should represent a text whose
authorship is to be predicted.}

\item{model}{A stylest2 model.}

\item{speaker_odds}{Should the model return log odds of authorship for each text, 
in addition to posterior probabilities?}

\item{term_influence}{Should the model return the influence of each term in determining
authorship over the prediction set, in addition to returning posterior probabilities?}

\item{prior}{Prior probability, defaults to \code{NULL}.}
}
\value{
A list object:
}
\description{
This function generates predicted probabilities of authorship for a set of texts.
It takes as an input a document-feature matrix of texts for which authorship is
to be predicted, as well as a stylest2 model containing potential authors.
}
\examples{
data(novels_dfm)
mod <- stylest2_fit(novels_dfm)
stylest2_predict(dfm=novels_dfm, model=mod)

}
