% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_glyph_segment.R
\name{geom_glyph_segment}
\alias{geom_glyph_segment}
\title{Create a Glyph Segment plot using ggplot2}
\usage{
geom_glyph_segment(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  x_major = NULL,
  x_minor = NULL,
  y_major = NULL,
  y_minor = NULL,
  yend_minor = NULL,
  width = "default",
  x_scale = identity,
  y_scale = identity,
  height = "default",
  global_rescale = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{x_major, x_minor, y_major, y_minor, yend_minor}{The name of the
variable (as a string) for the major and minor x and y axes. \code{x_major}
and \code{y_major} specify a longitude and latitude on a map while
\code{x_minor}, \code{y_minor}, and \code{yend_minor}
provide the structure for glyph.}

\item{width}{The width of each glyph. The `default` is set
to the smallest distance between two consecutive coordinates, converted from meters
to degrees of latitude using the Haversine method.}

\item{y_scale, x_scale}{The scaling function to be applied to each set of
minor values within a grid cell. The default is \code{\link{identity}} which
produces a result without scaling.}

\item{height}{The height of each glyph. The `default` is calculated using the ratio (1:1.618)
relative to the `width`, to maintain a consistent aspect ratio.}

\item{global_rescale}{Determines whether or not the rescaling is performed
globally or separately for each individual glyph.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
a ggplot object
}
\description{
This function enables the creation of segment glyphs by defining major
coordinates (longitude and latitude) and minor segment structures within
a grid cell. Each glyph's appearance can be customized by specifying its
height, width, and scaling, allowing for flexible data representation in a visual context.
}
\examples{
library(ggplot2)

# Basic glyph map with base map and custom theme
aus_temp |>
  ggplot(aes(x_major = long, y_major = lat,
         x_minor = month, y_minor = tmin, yend_minor = tmax)) +
  geom_sf(data = ozmaps::abs_ste, fill = "grey95",
          color = "white",inherit.aes = FALSE) +
  geom_glyph_segment() +
  ggthemes::theme_map()


# Adjust width and height of the glyph
aus_temp |>
  ggplot(aes(x_major = long, y_major = lat,
         x_minor = month, y_minor = tmin, yend_minor = tmax)) +
  geom_sf(data = ozmaps::abs_ste, fill = "grey95",
          color = "white",inherit.aes = FALSE) +
  geom_glyph_segment(width = rel(4.5), height = rel(3)) +
 ggthemes::theme_map()

# Extend glyph map with reference box and line
aus_temp |>
 ggplot(aes(x_major = long, y_major = lat,
         x_minor = month, y_minor = tmin, yend_minor = tmax)) +
  geom_sf(data = ozmaps::abs_ste, fill = "grey95",
          color = "white",inherit.aes = FALSE) +
  add_glyph_boxes() +
  add_ref_lines() +
  geom_glyph_segment() +
  ggthemes::theme_map()

}
