% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_group_tbl.R
\name{cat_group_tbl}
\alias{cat_group_tbl}
\title{Summarize two categorical variables}
\usage{
cat_group_tbl(
  data,
  row_var,
  col_var,
  margins = "all",
  na.rm.row_var = FALSE,
  na.rm.col_var = FALSE,
  pivot = "longer",
  only = NULL,
  ignore = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{row_var}{A character string of the name of a variable in \code{data}
containing categorical data. This is the primary categorical variable.}

\item{col_var}{A character string of the name of a variable in \code{data}
containing categorical data. This is the secondary categorical variable.}

\item{margins}{A character string that determines how percentage values
are calculated; whether they sum to one across rows, columns, or the
entire table (i.e., all). Defaults to \code{all}, but can also be set to
\code{rows} or \code{columns}.}

\item{na.rm.row_var}{A logical value indicating whether missing values for
\code{row_var} should be removed before calculations. Default is \code{FALSE}.}

\item{na.rm.col_var}{A logical value indicating whether missing values for
\code{col_var} should be removed before calculations. Default is \code{FALSE}.}

\item{pivot}{A character string that determines the format of the table. By
default, \code{longer} returns the data in the long format. To return the data in
the \code{wide} format, specify \code{wider}.}

\item{only}{A character string or vector of character strings of the types
of summary data to return. Default is \code{NULL}, which returns both counts and
percentages. To return only counts or percentages, use \code{count} or \code{percent},
respectively.}

\item{ignore}{An optional named vector or list that defines values to exclude
from \code{row_var} and \code{col_var}. If set to \code{NULL} (default), all values are retained.
To exclude multiple values from \code{row_var} or \code{col_var}, provide them as a named
list.}
}
\value{
A tibble showing the count and percentage of each category in \code{row_var}
by each category in \code{col_var}.
}
\description{
\code{cat_group_tbl()} summarizes nominal or categorical
variables by a grouping variable, returning frequency counts and
percentages.
}
\examples{
cat_group_tbl(data = nlsy,
              row_var = "gender",
              col_var = "bthwht",
              pivot = "wider",
              only = "count")

cat_group_tbl(data = nlsy,
              row_var = "birthord",
              col_var = "breastfed",
              pivot = "longer")

}
\author{
Ama Nyame-Mensah
}
