% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab}
\alias{tab}
\title{Create a cross-tabulation of two categorial variables}
\usage{
tab(data, variable1, variable2, test = "none")
}
\arguments{
\item{data}{The data frame or tibble}

\item{variable1}{The first categorical variable}

\item{variable2}{The second categorical variable}

\item{test}{Optional frequentist hypothesis test, use test=exact for Fisher's exact or test=chi for Chi squared}
}
\value{
A tibble with a cross-tabulation of frequencies and row percentages
}
\description{
Creates a "n x n" cross-tabulation of two categorical variables, with row percentages.
Includes options for adding frequentist hypothesis testing.

The function accepts an input from a dplyr pipe "\%>\%" and outputs the results as a tibble.

eg. example_data \%>\% tab(variable1, variable2)
}
\examples{
example_data <- dplyr::tibble(id = 1:100, group1 = sample(c("a", "b", "c", "d"),
                                                  size = 100, replace = TRUE),
                                                  group2= sample(c("male", "female"),
                                                  size = 100, replace = TRUE))
example_data$group1[sample(1:100, size = 10)] <- NA  # Replace 10 with missing
tab(example_data, group1, group2)
summary <- tab(example_data, group1, group2) # Save summary statistics as a tibble.
}
