% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surrogate.R
\name{surrogate}
\alias{surrogate}
\title{Surrogate Response}
\usage{
surrogate(object, method = c("latent", "jitter"),
  jitter.scale = c("probability", "response"), nsim = 1L, ...)
}
\arguments{
\item{object}{An object of class \code{\link[ordinal]{clm}},
\code{\link[rms]{lrm}}, \code{\link[rms]{orm}}, \code{\link[MASS]{polr}}, or
\code{\link[VGAM]{vglm}}.}

\item{method}{Character string specifying the type of surrogate to use; for
details, see Liu and Zhang (2017). For cumulative link models, the latent
variable method is used. For binary GLMs, the jittering approach is employed.
(Currently ignored.)}

\item{jitter.scale}{Character string specifying the scale on which to perform
the jittering. Should be one of \code{"probability"} or \code{"response"}.
(Currently ignored for cumulative link models.)}

\item{nsim}{Integer specifying the number of bootstrap replicates to use.
Default is \code{1L} meaning no bootstrap samples.}

\item{...}{Additional optional arguments. (Currently ignored.)}
}
\value{
A numeric vector of class \code{c("numeric", "surrogate")} containing
the simulated surrogate response values. Additionally, if \code{nsim} > 1,
then the result will contain the attributes:
\describe{
  \item{\code{boot.reps}}{A matrix  with \code{nsim} columns, one for each
  bootstrap replicate of the surrogate values. Note, these are random and do
  not correspond to the original ordering of the data;}
  \item{\code{boot.id}}{A matrix  with \code{nsim} columns. Each column
  contains the observation number each surrogate value corresponds to in
  \code{boot.reps}. (This is used for plotting purposes.)}
}
}
\description{
Simulate surrogate response values for cumulative link regression models
using the latent method described in Liu and Zhang (2017).
}
\note{
Surrogate response values require sampling from a continuous distribution;
consequently, the result will be different with every call to
\code{surrogate}. The internal functions used for sampling from truncated
distributions are based on modified versions of
\code{\link[truncdist]{rtrunc}} and \code{\link[truncdist]{qtrunc}}.
}
\references{
Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
Regression Models: A Surrogate Approach.
\emph{Journal of the American Statistical Association} (accepted). URL
http://www.tandfonline.com/doi/abs/10.1080/01621459.2017.1292915?journalCode=uasa20

Nadarajah, Saralees and Kotz, Samuel. R Programs for Truncated Distributions.
\emph{Journal of Statistical Software, Code Snippet}, 16(2), 1-8, 2006. URL
https://www.jstatsoft.org/v016/c02.
}
