% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvef.ph.R
\name{tvef.ph}
\alias{tvef.ph}
\title{testing the proportional hazards assumption from a \code{coxtv} or \code{coxtp} object}
\usage{
tvef.ph(fit, parm)
}
\arguments{
\item{fit}{fitted \code{coxtv} or \code{coxtp}  model.}

\item{parm}{the names of parameters to be tested.}
}
\value{
\code{tvef.ph} produces a matrix. Each row corresponds to a covariate from the fitted object. The three
columns give the test statistic, degrees of freedom and P-value.
}
\description{
Testing the proportional hazards assumption using a Wald test statistic.
}
\examples{
data(ExampleData)
z <- ExampleData$z
time <- ExampleData$time
event <- ExampleData$event
fit <- coxtv(event = event, z = z, time = time)
tvef.ph(fit)

}
\seealso{
\code{\link{tvef.zero}} \code{\link{tvef.zero.time}}
}
