% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.intELtest.R
\name{summary.intELtest}
\alias{summary.intELtest}
\title{Summary function for intELtest object}
\usage{
\method{summary}{intELtest}(object, digits = max(3L, getOption("digits") - 3L), quiet = FALSE, ...)
}
\arguments{
\item{object}{the result of a call to the \code{intELtest} function}

\item{digits}{significant digits to print, the default value is \code{max(3L, getOption("digits") - 3L)}}

\item{quiet}{a logical indicating whether to reduce the amount of output or not, the default value is \code{FALSE}}

\item{...}{for future method}
}
\value{
\code{summary.intELtest} returns a list with following components:
\itemize{
   \item \code{call} the statement used to create the \code{intELtest} object
   \item \code{teststat} the resulting integrated EL statistics
   \item \code{critval} the critical value based on bootstrap
   \item \code{pvalue} the p-value of the test
   \item \code{sided} the value of the input argument of intELtest
   \item \code{alpha} the value of the input argument of intELtest
}
}
\description{
Returns a list containing the integrated EL statistics, the critical value based on bootstrap, 
and the p-value of the test.
}
\examples{
library(survELtest)
result = intELtest(survival::Surv(hepatitis$time, hepatitis$censor) ~ hepatitis$group)
summary(result)

## OUTPUT:
## Call:
## intELtest(formula = survival::Surv(hepatitis$time, hepatitis$censor) ~ 
##     hepatitis$group)
## 
## Two-sided integrated EL test statistic = 1.42, p = 0.007,
## critical value based on bootstrap = 0.875 at a significance level of 0.05
}
\seealso{
\code{\link{hepatitis}}, \code{\link{intELtest}}, \code{\link{print.intELtest}}
}
