% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nocrossings.R
\name{summary.nocrossings}
\alias{summary.nocrossings}
\title{Summary function for nocrossings object}
\usage{
\method{summary}{nocrossings}(object, digits = max(3L, getOption("digits") - 3L), quiet = FALSE, ...)
}
\arguments{
\item{object}{the result of a call to the \code{nocrossings} function}

\item{digits}{significant digits to print, the default value is \code{max(3L, getOption("digits") - 3L)}}

\item{quiet}{a logical indicating whether to reduce the amount of output or not, the default value is \code{FALSE}}

\item{...}{for future method}
}
\value{
\code{summary.nocrossings} returns a list with following components:
\itemize{
   \item \code{call} the statement used to create the \code{nocrossings} object
   \item \code{decision} \eqn{1} for rejection of the null hypothesis that there are crossings or alternative orderings among the survival functions, and \eqn{0} otherwise
}
}
\description{
Returns the decision for rejection of the null hypothesis that there are crossings or alternative orderings among the survival functions.
}
\examples{
library(survELtest)
result = nocrossings(survival::Surv(hepatitis$time, hepatitis$censor)~
          hepatitis$group, sided = 1)
summary(result)

## OUTPUT:
## Call:
## nocrossings(formula = survival::Surv(hepatitis$time, hepatitis$censor) ~ 
##     hepatitis$group, sided = 1)
## 
## Decision = 1
}
\seealso{
\code{\link{hepatitis}}, \code{\link{nocrossings}}, \code{\link{print.nocrossings}}
}
