% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_sim_est.R
\name{survey_sim_est}
\alias{survey_sim_est}
\title{Estimation of Finite Population Total under Complex Sampling Design Viz. SRSWOR}
\usage{
survey_sim_est(Y, X, n = 40, SimNo = 500, seed = NULL)
}
\arguments{
\item{Y}{Numeric vector. The study variable for which the population total is to be estimated.}

\item{X}{Numeric vector. The auxiliary variable used for ratio and regression estimators.}

\item{n}{Integer. Sample size to be drawn from the population in each simulation (default is 40).}

\item{SimNo}{Integer. Number of simulations or iterations to be performed (default is 500).}

\item{seed}{Integer. Random seed for reproducibility (default is 123).}
}
\value{
A data frame with the following columns:
- Est_Total: Estimated population total of HT, Ratio, and Regression estimators.
- RB: Relative Bias (%) of each estimator.
- RRMSE: Relative Root Means Square Error (%) of each estimator.
- Skewness: Skewness of estimator distributions.
- Kurtosis: Kurtosis of estimator distributions.
- Coverage: Coverage probability (within ±1.96 SE of true total) of each estimator.
- PopVar: Theoretical variance of each estimator.
- EmpVar: Empirical variance from simulations.
- EstVar: Average estimate of variances across simulations.
- CV: Coefficient of variation (%) of each estimator.
}
\description{
Sample surveys use scientific methods to draw inferences about population parameters by observing a representative part of the population, called sample.SRSWOR (Simple Random Sampling Without Replacement) is one of the most widely used probability sampling designs,wherein every unit has an equal chance of being selected and units are not repeated.This function draws multiple SRSWOR samples from a finite population and estimates the population parameter i.e. total of HT, Ratio, and Regression estimators.Repeated simulations (e.g., 500 times) are used to assess and compare estimators using metrics such as percent relative bias (%RB),percent relative root means square error (%RRMSE).
}
\details{
This function evaluates and compares the performance of three estimators—Horvitz-Thompson (HT), Ratio, and Regression-for estimating the finite population total using repeated sampling and simulation under Simple Random Sampling Without Replacement (SRSWOR).
}
\examples{
set.seed(101)
N <- 400
X <- runif(N, 5, 15)
Y <- 10 + 2 * X + rnorm(N, sd = 2)
survey_sim_est(Y, X, n = 40, SimNo = 500)

}
\references{
1. Cochran, W. G. (1977). \emph{Sampling Techniques, 3rd Edition}. New York: John Wiley & Sons, Inc.

2. Singh, D. and Chaudhary, F.S. (1986). \emph{Theory and Analysis of Sample Survey Designs}. New York: John Wiley & Sons, Inc.

3. Sukhatme, P.V., Sukhatme, B.V., Sukhatme, S. and Asok, C. (1984). \emph{Sampling Theory of Surveys with Applications}. Iowa State University Press, Ames and Indian Society of Agricultural Statistics, New Delhi.

4. Särndal, C.-E., Swensson, B., & Wretman, J. (1992). Model Assisted Survey Sampling. Springer.
}
