% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.coxph_mpl_dc.R
\name{plot.coxph_mpl_dc}
\alias{plot.coxph_mpl_dc}
\title{Plot a baseline hazard estimates from coxph_mpl_dc Object}
\usage{
\method{plot}{coxph_mpl_dc}(
  x,
  parameter = "theta",
  funtype = "hazard",
  xout,
  se = TRUE,
  ltys,
  cols,
  ...
)
}
\arguments{
\item{x}{an object inheriting from class \code{\link{coxph_mpl_dc}}}

\item{parameter}{the set of parameters of interest.  Indicate \code{parameters="theta"} for the baseline hazard
estimated by \eqn{theta} and \code{parameters="gamma"} for the baseline hazard estimated by \eqn{gamma}}

\item{funtype}{the type of function for ploting, i.e. \code{funtype="hazard"} for baseline hazard,
\code{funtype="cumhazard"} for baseline cumulative hazard and \code{funtype="survival"} for
baseline survival function}

\item{xout}{the time values for the baseline hazard plot}

\item{se}{se=TRUE gives both the MPL baseline estimates and 95\% confidence interval plots while se=FALSE
gives only the MPL baseline estimate plot.}

\item{ltys}{a line type vector with two components, the first component is the line type of the baseline hazard
while the second component is the line type of the 95\% confidence interval}

\item{cols}{a colour vector with two components, the first component is the colour of the baseline hazard
while the second component is the colour the 95\% confidence interval}

\item{...}{other arguments}
}
\value{
the baseline hazard plot
}
\description{
Plot the baseline hazard with the confidence interval estimates
}
\details{
When the input is of class \code{coxph_mpl_dc} and \code{parameters=="theta"}, the baseline estimates
base on \eqn{\theta} and xout (with the corresponding 95\% confidence interval if se=TRUE ) are ploted.
When the input is of class \code{coxph_mpl_dc} and \code{parameters=="gamma"}, the baseline hazard estimates
based on \eqn{\gamma} and xout (with the corresponding 95\% confidence interval if se=TRUE ) are ploted.
}
\examples{
\donttest{
 ##-- Copula types
 copula3 <- 'frank'

##-- A real example
##-- One dataset from Prospective Research in Memory Clinics (PRIME) study
##-- Refer to article Brodaty et al (2014),
##   the predictors of institutionalization of dementia patients over 3-year study period

data(PRIME)

surv<-as.matrix(PRIME[,1:3]) #time, event and dependent censoring indicators
cova<-as.matrix(PRIME[, -c(1:3)]) #covariates
colMeans(surv[,2:3])  #the proportions of event and dependent censoring

n<-dim(PRIME)[1];print(n)
p<-dim(PRIME)[2]-3;print(p)
names(PRIME)

##--MPL estimate Cox proportional hazard model for institutionalization under medium positive
##--dependent censoring
control <- coxph_mpl_dc.control(ordSp = 4,
                                binCount = 200, tie = 'Yes',
                                tau = 0.5, copula = copula3,
                                pent = 'penalty_mspl', smpart = 'REML',
                                penc = 'penalty_mspl', smparc = 'REML',
                                cat.smpar = 'No' )

coxMPLests_tau <- coxph_mpl_dc(surv=surv, cova=cova, control=control, )

plot(x = coxMPLests_tau, parameter = "theta", funtype="hazard",
     xout = seq(0, 36, 0.01), se = TRUE,
     cols=c("blue", "red"), ltys=c(1, 2), type="l", lwd=1, cex=1, cex.axis=1, cex.lab=1,
     xlab="Time (Month)", ylab="Hazard",
     xlim=c(0, 36), ylim=c(0, 0.05)
     )
     title("MPL Hazard", cex.main=1)
     legend( 'topleft',legend = c( expression(tau==0.5), "95\% Confidence Interval"),
     col = c("blue", "red"),
     lty = c(1, 2),
     cex = 1)

plot(x = coxMPLests_tau, parameter = "theta", funtype="cumhazard",
    xout = seq(0, 36, 0.01), se = TRUE,
    cols=c("blue", "red"), ltys=c(1, 2),
    type="l", lwd=1, cex=1, cex.axis=1, cex.lab=1,
    xlab="Time (Month)", ylab="Hazard",
    xlim=c(0, 36), ylim=c(0, 1.2)
)
title("MPL Cumulative Hazard", cex.main=1)
legend( 'topleft',
       legend = c( expression(tau==0.5), "95\% Confidence Interval"),
       col = c("blue", "red"),
       lty = c(1, 2),
       cex = 1
)

plot(x = coxMPLests_tau, parameter = "theta", funtype="survival",
    xout = seq(0, 36, 0.01), se = TRUE,
    cols=c("blue", "red"), ltys=c(1, 2),
    type="l", lwd=1, cex=1, cex.axis=1, cex.lab=1,
    xlab="Time (Month)", ylab="Hazard",
    xlim=c(0, 36), ylim=c(0, 1)
)
title("MPL Survival", cex.main=1)
legend( 'bottomleft',
       legend = c( expression(tau==0.5), "95\% Confidence Interval"),
       col = c("blue", "red"),
       lty = c(1, 2),
       cex = 1
)

}

}
\references{
Brodaty H, Connors M, Xu J, Woodward M, Ames D. (2014). \emph{"Predictors of institutionalization
in dementia: a three year longitudinal study"}. Journal of Alzheimers Disease 40, 221-226.

Xu J, Ma J, Connors MH, Brodaty H. (2018). \emph{"Proportional hazard model estimation under dependent censoring using copulas and penalized likelihood"}.
Statistics in Medicine 37, 2238–2251.
}
\seealso{
\code{\link{coef.coxph_mpl_dc}}, \code{\link{coxph_mpl_dc.control}}, \code{\link{coxph_mpl_dc}}
}
\author{
Jing Xu, Jun Ma, Thomas Fung
}
