% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_addcalendarevent.R
\name{suso_gql_addassignmentcalendarevent}
\alias{suso_gql_addassignmentcalendarevent}
\title{Add a calendar event to an Assignment}
\usage{
suso_gql_addassignmentcalendarevent(
  endpoint = NULL,
  workspace = NULL,
  user = NULL,
  password = NULL,
  token = NULL,
  assignmentId = NULL,
  comment = NULL,
  newStart = NULL,
  startTimezone = "UTC"
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server}

\item{workspace}{Server Workspace, if NULL uses default}

\item{user}{your API username}

\item{password}{your API user password}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored}

\item{assignmentId}{assignment id}

\item{comment}{a comment string}

\item{newStart}{new start date, format must be: \code{2024-01-16 01:41:14}}

\item{startTimezone}{time zone of the tablet device, use \code{\link[base]{OlsonNames}}}
}
\value{
if successfull, returns a list with the executed mutation
}
\description{
Add a calendar event to an assignment
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and API credentials

# Create a calendar event for assignment 208 on 2024-01-16 01:41:14,
# in timezone Chile/Continental

suso_gql_addassignmentcalendarevent(endpoint = ep, user = usr,
password = pass, workspace = ws, assignmentId = 208, newStart = "2024-01-16 01:41:14",
startTimezone = "Chile/Continental", comment = "Lets Go!")
\dontshow{\}) # examplesIf}
}
