% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestOneMuSmfg.R
\name{test1musm}
\alias{test1musm}
\title{Tests the hypothesis over population mean based on one sample summary statistics by Sv-plot2.}
\usage{
test1musm(n=20,xbar=3,s=2,mu0=4.5,alpha=0.05,
                 unkwnsigma=TRUE,sigma=NULL,xlab="x",
                 title="Single mean summary: Hypothesis testing by Sv-plot2",
                 samcol="grey5",popcol="grey45",thrcol="black",...)
}
\arguments{
\item{n}{sample size, \emph{n=20} by default.}

\item{xbar}{sample average, \emph{xbar=3} by default.}

\item{s}{sample standard deviation, \emph{s=2} by default.}

\item{mu0}{hypothesized population mean, \emph{mu0=4.5} by default.}

\item{alpha}{significance level, \emph{alpha=0.05} by default.}

\item{unkwnsigma}{population standard deviation is unknown, \emph{TRUE} by default.}

\item{sigma}{population standard deviation, \emph{NULL} by default.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{title}{title of the plot, \emph{Single mean: Hypothesis testing by Sv-plot2 by default} by default.}

\item{samcol}{sample Sv-plot2 color, \emph{grey5} by default.}

\item{popcol}{sample Sv-plot2 color, \emph{grey45} by default.}

\item{thrcol}{threshold color, \emph{black}.}

\item{...}{other graphical parameters.}
}
\value{
Decision on testing hypotheses over single population mean by Sv-plot2.
}
\description{
Decision on hypothesis testing over single mean is made by graphing sample and population Sv-plot2s along with the threshold line. Intersecting Sv-plots on or above the horizontal line concludes the alternative hypothesis.
}
\examples{
 ## For summary data
    test1musm(n=20,xbar=3,s=2,mu0=4.5,alpha=0.05, unkwnsigma=TRUE,sigma=NULL,xlab="x",
    title="Single mean summary: Hypothesis testing by Sv-plot2",
    samcol="grey5",popcol="grey45",thrcol="black")
}
\references{
Wijesuriya, U. A. (2020). Sv-plots for identifying characteristics of the
            distribution and testing hypotheses. \emph{Communications in Statistics-Simulation and Computation}, \doi{10.1080/03610918.2020.1851716}.
}
