% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestTwoMuSmfg.R
\name{test2musm}
\alias{test2musm}
\title{Tests the hypothesis over two population means based on two samples summary statistics by Sv-plot2.}
\usage{
test2musm(n1=20,n2=25,xbar1=3,xbar2=4,s1=1,s2=1.5,
                 paired=FALSE,eqlvar=FALSE,unkwnsigmas=TRUE,
                 sigma1=NULL,sigma2=NULL,sdevdif=NULL,alpha=0.05,
                 xlab="x",title="Two means summary: Hypothesis testing by Sv-plot2",
                 sam1col="grey5",sam2col="grey45",thrcol="black",...)
}
\arguments{
\item{n1}{sample1 size,  \emph{n1=20} by default.}

\item{n2}{sample2 size,  \emph{n2=25} by default.}

\item{xbar1}{sample1 average, \emph{xbar1=3} by default.}

\item{xbar2}{sample2 average, \emph{xbar2=4} by default.}

\item{s1}{sample1 standard deviation, \emph{s1=1} by default.}

\item{s2}{sample2 standard deviation, \emph{s2=1.5} by default.}

\item{paired}{for dependent samples TRUE, \emph{FALSE} by default.}

\item{eqlvar}{population variances are equal, \emph{FALSE} by default.}

\item{unkwnsigmas}{population standard deviations are unknown, \emph{TRUE} by default.}

\item{sigma1}{population1  standard deviation, \emph{NULL} by default.}

\item{sigma2}{population2  standard deviation, \emph{NULL} by default.}

\item{sdevdif}{standard deviation of the differences, \emph{NULL} by default.}

\item{alpha}{significance level, \emph{alpha=0.05} by default.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{title}{title of the plot, \emph{Two means: Hypothesis testing by Sv-plot2} by default.}

\item{sam1col}{sample1 Sv-plot2 color, \emph{grey5} by default.}

\item{sam2col}{sample2 Sv-plot2 color, \emph{grey45} by default.}

\item{thrcol}{threshold color, \emph{black} by default.}

\item{...}{other graphical parameter.}
}
\value{
Decision on testing hypotheses over two population means by Sv-plot2.
}
\description{
Decision on hypothesis testing over two means is made by graphing two sample Sv-plot2s along with the threshold line. Intersecting Sv-plots on or above the horizontal line concludes the alternative hypothesis.
}
\examples{
 ## For summary data
test2musm(n1=20,n2=25,xbar1=3,xbar2=4,s1=1,s2=1.5,
         paired=FALSE,eqlvar=FALSE,unkwnsigmas=TRUE,
         sigma1=NULL,sigma2=NULL,sdevdif=NULL,alpha=0.05,
         xlab="x",title="Two means summary: Hypothesis testing by Sv-plot2",
         sam1col="grey5",sam2col="grey45",thrcol="black")

test2musm(n1=20,n2=25,xbar1=3,xbar2=4,s1=1.5,s2=1.5,
        paired=FALSE,eqlvar=TRUE,unkwnsigmas=TRUE,
        sigma1=NULL,sigma2=NULL,sdevdif=NULL,alpha=0.05,
        xlab="x",title="Two means summary: Hypothesis testing by Sv-plot2",
        sam1col="grey5",sam2col="grey45",thrcol="black")

test2musm(n1=50,n2=35,xbar1=3,xbar2=4,s1=1,s2=1.5,
         paired=FALSE,eqlvar=FALSE,unkwnsigmas=TRUE,
         sigma1=NULL,sigma2=NULL,sdevdif=NULL,alpha=0.05,
         xlab="x",title="Two means summary: Hypothesis testing by Sv-plot2",
         sam1col="grey5",sam2col="grey45",thrcol="black")

test2musm(n1=50,n2=35,xbar1=3,xbar2=4,s1=1,s2=1.5,
         paired=FALSE,eqlvar=FALSE,unkwnsigmas=FALSE,
         sigma1=2,sigma2=3,sdevdif=NULL,alpha=0.05,
         xlab="x",title="Two means summary: Hypothesis testing by Sv-plot2",
         sam1col="grey5",sam2col="grey45",thrcol="black")

test2musm(n1=20,n2=20,xbar1=3,xbar2=4,s1=1,s2=1.5,
         paired=TRUE,eqlvar=FALSE,unkwnsigmas=TRUE,
         sigma1=NULL,sigma2=NULL,sdevdif=2,alpha=0.05,
         xlab="x",title="Two means summary: Hypothesis testing by Sv-plot2",
         sam1col="grey45",sam2col="grey5",thrcol="black")
}
\references{
Wijesuriya, U. A. (2020). Sv-plots for identifying characteristics of the
            distribution and testing hypotheses. \emph{Communications in Statistics-Simulation and Computation}, \doi{10.1080/03610918.2020.1851716}.
}
