% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratic_forms.R
\name{ht_matrix_to_joint_probs}
\alias{ht_matrix_to_joint_probs}
\title{Compute the matrix of joint inclusion probabilities
from the quadratic form of a Horvitz-Thompson variance estimator.}
\usage{
ht_matrix_to_joint_probs(ht_quad_form)
}
\arguments{
\item{ht_quad_form}{The matrix of the quadratic form
representing the Horvitz-Thompson variance estimator.}
}
\value{
The matrix of joint inclusion probabilities
}
\description{
Compute the matrix of joint inclusion probabilities
from the quadratic form of a Horvitz-Thompson variance estimator.
}
\details{
The quadratic form matrix of the Horvitz-Thompson variance estimator
has \eqn{ij}-th entry equal to \eqn{(1-\frac{\pi_i \pi_j}{\pi_{ij}})}.
The matrix of joint probabilities has \eqn{ij}-th entry equal to \eqn{\pi_{ij}}.
}
\keyword{internal}
