% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.svr.R
\name{solve.svr}
\alias{solve.svr}
\title{QP solver for SVR}
\usage{
\method{solve}{svr}(a, b, lambda = 1, svr.eps = 1,
  kernel.function = radial.kernel, param.kernel = 1, ...)
}
\arguments{
\item{a}{The data matrix (n x p) with n rows (observations) on p variables (columns)}

\item{b}{The real number valued response variable}

\item{lambda}{The regularization parameter}

\item{svr.eps}{Epsilon in epsion-insensitive loss function}

\item{kernel.function}{User defined kernel function. See \code{svmpath}.}

\item{param.kernel}{Parameter(s) of the kernels. See \code{svmpath}.}

\item{...}{Generic compatibility}
}
\value{
SVR solution at a given \code{lambda} and \code{epsilon}
}
\description{
solves quadratic programming(QP) for SVR.
}
\examples{
\donttest{
# set.seed(1)
n <- 30
p <- 50

x <- matrix(rnorm(n*p), n, p)
e <- rnorm(n, 0, 1)
beta <- c(1, 1, rep(0, p-2))
y <- x \%*\% beta + e
solve.svr(x, y) }

}
\author{
Dohyun Kim, Seung Jun Shin
}
