% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross-sectional.R
\name{run_all_diagnostic_tests}
\alias{run_all_diagnostic_tests}
\alias{print.run_all_diagnostic_tests}
\title{Run All Diagnostic Tests for Informative Weights}
\usage{
run_all_diagnostic_tests(model, alpha = 0.05, B = 1000)

\method{print}{run_all_diagnostic_tests}(x, ...)
}
\arguments{
\item{model}{A fitted \code{svyglm} object.}

\item{alpha}{Critical value for rejection (default 0.05).}

\item{B}{Number of permutations for permutation tests (default 1000).}

\item{x}{An object of class run_all_diagnostic_tests}

\item{...}{Additional arguments passed to methods}
}
\value{
A list with:
  \item{results}{Data frame of test names, statistics, p-values, reject indicator}
  \item{recommendation}{Character string with suggested action}
  \item{raw}{List of raw test outputs, including permutation test objects}
}
\description{
This function runs all implemented diagnostic tests:
  - \code{\link{wa_test}}() with types "DD", "PS1", "PS1q", "PS2", "PS2q", "WF"
  - \code{\link{diff_in_coef_test}}()
  - \code{\link{estim_eq_test}}()
  - \code{\link{perm_test}}() with stats "pred_mean" and "coef_mahal"
}
\examples{
# Load in survey package (required) and load in example data
library(survey)
data(api, package = "survey")

# Create a survey design and fit a weighted regression model
des <- svydesign(id = ~1, strata = ~stype, weights = ~pw, data = apistrat)
fit <- svyglm(api00 ~ ell + meals, design = des)

# Run all diagnostic tests and return a list of statistics, including a recommendation
results <- run_all_diagnostic_tests(fit)
print(results)

}
\seealso{
\code{\link{wa_test}}, \code{\link{diff_in_coef_test}},
  \code{\link{estim_eq_test}}, \code{\link{perm_test}}
}
