% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_pos.R
\name{frontness}
\alias{frontness}
\title{Frontness}
\usage{
frontness(bs)
}
\arguments{
\item{bs}{A vector of bearing angles (in rad) between objects.}
}
\value{
A vector of the same length as bs representing the frontness of
a focal object to its neighbor.
}
\description{
Given the bearing angle of an object to another, this function
 calculates the frontness, a value that ranges from 0 to 1 and represents how
 in front the focal object is from its neighbor.
}
\examples{
bs <- runif(25, max = pi)
frontness(bs)

}
\seealso{
\code{\link{nnba}}
}
\author{
Marina Papadopoulou, \email{m.papadopoulou.rug@gmail.com}
}
