% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-aco.R
\name{read_aco}
\alias{read_aco}
\title{Read colors from Adobe Color (ACO) files}
\usage{
read_aco(path, use_names = TRUE, .verbose = FALSE)
}
\arguments{
\item{path}{partial or full file path or URL to an ACO file}

\item{use_names}{add color names to the vector (defaults to \code{TRUE}). See NOTE}

\item{.verbose}{show extra information about ACO file processing}
}
\description{
Given a path or URL to an \code{.aco} file, this function will return
a named character vector (if color names are present) of hex RGB colors.
}
\note{
When using named color palettes in a \code{ggplot2} \code{scale_} context, you
    must \code{unname}, set \code{use_names} to \code{FALSE} or override their names
    to map to your own factor levels.
}
\examples{
# built-in palette
eighties <- read_aco(system.file("palettes", "tomorrow_night_eighties.aco", package="swatches"))
print(eighties)
show_palette(eighties)

# from the internet directly
\dontrun{
tomorrow_night <- read_aco("https://bit.ly/tomorrow-night-aco")
print(tomorrow_night)
show_palette(tomorrow_night)
}
}
