% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soc.R
\name{read_soc}
\alias{read_soc}
\title{Read colors from OpenOffice Palette (SOC) files}
\usage{
read_soc(path, use_names = TRUE, .verbose = FALSE)
}
\arguments{
\item{path}{partial or full file path or URL to a GPL file}

\item{use_names}{add color names to the vector (defaults to \code{TRUE}). See NOTE}

\item{.verbose}{show extra information about GPL file processing}
}
\description{
Given a path or URL to an \code{.soc} file, this function will return
a named character vector (if color names are present) of hex RGB colors.
}
\note{
When using named color palettes in a \code{ggplot2} \code{scale_} context, you
    must \code{unname}, set \code{use_names} to \code{FALSE} or override their names
    to map to your own factor levels.
}
\examples{
# built-in palette
soc_file <- system.file("palettes", "ccooo.soc", package="swatches")
system(sprintf("cat \%s", soc_file))
ccooo <- read_soc(soc_file)
print(ccooo)
show_palette(ccooo)

# from the internet directly
\dontrun{
galaxy <- read_soc("https://www.openoffice.org/ui/VisualDesign/docs/colors/galaxy.soc")
print(galaxy)
show_palette(galaxy)
}
}
