% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{dataSlice}
\alias{dataSlice}
\title{Subset or Resample idframe data}
\usage{
dataSlice(data, start = NULL, end = NULL, freq = NULL)
}
\arguments{
\item{data}{an object of class \code{idframe}}

\item{start}{the start index}

\item{end}{the end index}

\item{freq}{fraction of the original frequency at which the series
to be sampled.}
}
\value{
an idframe object
}
\description{
\code{dataSlice} is a subsetting method for objects of class \code{idframe}. It 
extracts the subset of the object \code{data} observed between indices \code{start}
and \code{end}.  If a frequency is specified, the series is then re-sampled at the 
new frequency.
}
\details{
The dataSlice function extends the \code{\link[stats]{window}} 
function for idframe objects
}
\examples{
data(cstr)
cstrsub <- dataSlice(cstr,start=200,end=400) # extract between indices 200 and 400
cstrTrain <- dataSlice(cstr,end=4500) # extract upto index 4500
cstrTest <- dataSlice(cstr,start=6501) # extract from index 6501 till the end
cstr_new <- dataSlice(cstr,freq=0.5) # resample data at half the original frequency  

}
\seealso{
\code{\link[stats]{window}}
}

