% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\name{read.table.idframe}
\alias{read.table.idframe}
\title{Read the contents of a table-formatted file}
\usage{
read.table.idframe(file, header = TRUE, sep = ",", ninputs = 0, Ts = 1,
  unit = c("seconds", "minutes", "hours", "days")[1], ...)
}
\arguments{
\item{file}{the path to the file to read}

\item{header}{a logical value indicating whether the first row corresponding to 
the first element of the rowIndex vector contains the names of the variables. 
(Default: \code{TRUE})}

\item{sep}{the field separator character. Values on each line of the file are 
separated by this character. (Default: \code{","})}

\item{ninputs}{the number of input columns. (Default: 0)}

\item{Ts}{sampling interval (Default: 1)}

\item{unit}{Time Unit (Default: "seconds")}

\item{...}{additional arguments to be passed to the \code{\link[utils]{read.table}} function}
}
\value{
an idframe object
}
\description{
Read the contents of an file in table format into a \code{idframe} object.
}
\details{
The \code{read.table.idframe} function uses the \code{\link[utils]{read.table}} function, 
provided by the \pkg{utils} package, to read data from a table-formatted file and then calls the 
\code{\link{read.idframe}} function to read the data into a idframe object
}
\examples{
dataMatrix <- data.frame(matrix(rnorm(1000),ncol=5))
colnames(dataMatrix) <- c("u1","u2","y1","y2","y3")
write.csv(dataMatrix,file="test.csv",row.names=FALSE)
 
data <- read.table.idframe("test.csv",ninputs=2,unit="minutes")

}
\seealso{
\code{\link[utils]{read.table}}
}

