% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{[.tableMatrix}
\alias{[.tableMatrix}
\alias{[<-.tableMatrix}
\title{Bracket}
\usage{
\method{[}{tableMatrix}(x, ...)

\method{[}{tableMatrix}(x, i, j) <- value
}
\arguments{
\item{x}{\code{tableMatrix} object.}

\item{...}{Passed arguments.}

\item{i}{Same as \code{i} in \code{data.table}}

\item{j}{Same as \code{j} in \code{data.table}}

\item{value}{Value to be set.}
}
\value{
\code{tableMatrix} or vector.
}
\description{
\code{tableMatrix} method, passes data.table bracket functionality to the table attribute.
Assigning works only for \code{tab} part and only \code{i} and \code{j} from \code{data.table}
is used. If \code{j} is numeric, it corresponds to first attribute after \code{tmName} names.

Bracket
}
\examples{

data(images8By8)

# Create tableMatrix from images8By8
TM <- tableMatrix(images8By8, 1:3, 4:ncol(images8By8))


TM[2,1] <- "aaa"

TM[1,"dimX"] <- 1000

# setting row
TM[2,] <- list("aaa", 1000, 1000)

# setting column
TM[,2] <- 1

}
