% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{xls_theme_default}
\alias{xls_theme_default}
\title{Constructor function for the default xls theme}
\usage{
xls_theme_default(
  title = openxlsx::createStyle(fontSize = 16, textDecoration = "bold"),
  footnote1 = openxlsx::createStyle(fontSize = 12),
  footnote2 = openxlsx::createStyle(fontSize = 12),
  footnote3 = openxlsx::createStyle(fontSize = 12),
  col_header = openxlsx::createStyle(fontSize = 12, textDecoration = "bold", border =
    c("top", "bottom", "left", "right"), borderStyle = "thin", wrapText = TRUE, halign =
    "center"),
  character = openxlsx::createStyle(fontSize = 12, border = c("top", "bottom", "left",
    "right"), borderStyle = "thin"),
  number = openxlsx::createStyle(fontSize = 12, numFmt = "### ### ### ##0", border =
    c("top", "bottom", "left", "right"), borderStyle = "thin"),
  decimal = openxlsx::createStyle(fontSize = 12, numFmt = "### ### ### ##0.0", border =
    c("top", "bottom", "left", "right"), borderStyle = "thin"),
  percent = openxlsx::createStyle(fontSize = 12, numFmt = "#0.0", border = c("top",
    "bottom", "left", "right"), borderStyle = "thin", halign = "center"),
  mergedcell = openxlsx::createStyle(fontSize = 12, border = c("top", "bottom", "left",
    "right"), borderStyle = "thin", wrapText = TRUE, valign = "center", halign =
    "center"),
  ...
)
}
\arguments{
\item{title}{Style for the title}

\item{footnote1}{Style for footnote1}

\item{footnote2}{Style for footnote2}

\item{footnote3}{Style for footnote3}

\item{col_header}{Style for the columns header}

\item{character}{Default style for data cells}

\item{number}{Style for columns in number format}

\item{decimal}{Style for columns in decimal format}

\item{percent}{Style for columns in percent format}

\item{mergedcell}{Style for merged cells}

\item{...}{Other (named) custom styles}
}
\value{
a named list of class xls_theme, whose elements are `openxlsx` Style objects.
}
\description{
This function is a wrapper around [xls_theme()] that creates an xls theme for styling exported tables.
It defines a theme whith sensible default formatting values.
It also defines custom styles for "number", "decimal" and "percent column types.
All its arguments must be `openxlsx` Style objects.
}
\examples{
# default theme
xls_theme_default()

# default theme with title in italic
my_theme <- xls_theme_default(title = openxlsx::createStyle(textDecoration = "italic"))

\dontrun{
toxlsx(object = iris, path = tempdir(), theme = my_theme)
}
}
\seealso{
\code{\link[tablexlsx:xls_theme]{xls_theme()}},
\code{\link[tablexlsx:xls_theme_plain]{xls_theme_plain()}}
}
