% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{xls_theme_plain}
\alias{xls_theme_plain}
\title{Constructor function for a plain xls theme}
\usage{
xls_theme_plain(
  title = openxlsx::createStyle(),
  col_header = openxlsx::createStyle(),
  character = openxlsx::createStyle(),
  footnote1 = openxlsx::createStyle(),
  footnote2 = openxlsx::createStyle(),
  footnote3 = openxlsx::createStyle(),
  mergedcell = openxlsx::createStyle(),
  ...
)
}
\arguments{
\item{title}{Style for the title}

\item{col_header}{Style for the columns header}

\item{character}{Default style for data cells}

\item{footnote1}{Style for footnote1}

\item{footnote2}{Style for footnote2}

\item{footnote3}{Style for footnote3}

\item{mergedcell}{Style for merged cells}

\item{...}{Other (named) custom styles}
}
\value{
a named list of class xls_theme, whose elements are `openxlsx` Style objects.
}
\description{
This function is a wrapper around [xls_theme()] that creates an xls theme for styling exported tables.
It defines a simple theme whith no special formatting.
All its arguments must be `openxlsx` Style objects.
}
\examples{
# plain theme
xls_theme_plain()

# plain theme with title in bold
my_theme <- xls_theme_plain(title = openxlsx::createStyle(textDecoration = "bold"))

\dontrun{
toxlsx(object = iris, path = tempdir(), theme = my_theme)
}
}
\seealso{
\code{\link[tablexlsx:xls_theme]{xls_theme()}},
\code{\link[tablexlsx:xls_theme_default]{xls_theme_default()}}
}
