% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimate.R
\name{decimate}
\alias{decimate}
\title{Decimate swiftly and ruthlessly}
\usage{
decimate(x, dec = 10)
}
\arguments{
\item{x}{raster object (single layer).}

\item{dec}{decimation factor, raw multiplier for the resolution of the output}
}
\value{
raster layer
}
\description{
Reduce the resolution of a \code{\link[raster]{raster}} by ruthless decimation.
}
\details{
This is fast, it's just fast extraction with no care taken for utility purposes when you need
to reduce the detail.
}
\examples{
library(raster)
plot(decimate(raster(volcano)))
contour(raster(volcano), add = TRUE)
}
