% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationGumbel.R
\name{AsymVarGumbel}
\alias{AsymVarGumbel}
\title{Asymptotic variance matrix for the Gumbel model.}
\usage{
AsymVarGumbel(indices, par, method)
}
\arguments{
\item{indices}{A \eqn{q} x \eqn{d} matrix containing at least 2 non-zero elements per row, representing the values in which we will evaluate the stable tail dependence function. For \code{method = Mestimator}, this matrix should contain exactly two ones per row.}

\item{par}{The parameter of the Gumbel model.}

\item{method}{Choose between "Mestimator" and "WLS".}
}
\value{
A \code{q} by \code{q} matrix.
}
\description{
Computes the asymptotic variance matrix for the Gumbel model, estimated using the pairwise M-estimator or the weighted least squares estimator.
}
\details{
The matrix \code{indices} can be either user defines or returned by \code{selectGrid}. For \code{method = "Mestimator"}, only a grid with exactly two ones per row is accepted, representing the pairs to be used.
}
\examples{
indices <- selectGrid(c(0,1), d = 3, nonzero = c(2,3))
AsymVarGumbel(indices, par = 0.7, method = "WLS")
}
\references{
Einmahl, J.H.J., Kiriliouk, A., Krajina, A., and Segers, J. (2016). An Mestimator of spatial tail dependence. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 78(1), 275-298.

Einmahl, J.H.J., Kiriliouk, A., and Segers, J. (2018). A continuous updating weighted least squares estimator of tail dependence in high dimensions. Extremes 21(2), 205-233.
}
\seealso{
\code{\link{selectGrid}}
}
