% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationGumbel.R
\name{EstimationGumbel}
\alias{EstimationGumbel}
\title{Estimation of the parameter of the Gumbel model}
\usage{
EstimationGumbel(
  x,
  indices,
  k,
  method,
  biascorr = FALSE,
  k1 = (nrow(x) - 10),
  tau = 5,
  covMat = TRUE
)
}
\arguments{
\item{x}{An \eqn{n} x \eqn{d} data matrix.}

\item{indices}{A \eqn{q} x \eqn{d} matrix containing at least 2 non-zero elements per row, representing the values in which we will evaluate the stable tail dependence function. For \code{method = Mestimator}, this matrix should contain exactly two ones per row.}

\item{k}{An integer between 1 and \eqn{n - 1}; the threshold parameter in the definition of the empirical stable tail dependence function.}

\item{method}{Choose between \code{Mestimator} and \code{WLS}.}

\item{biascorr}{For \code{method = "WLS"} only. If \code{TRUE}, then the bias-corrected estimator of the stable tail dependence function is used. Defaults to \code{FALSE}.}

\item{k1}{For \code{biascorr = TRUE} only. The value of \eqn{k_1} in the definition of the bias-corrected estimator of the stable tail dependence function.}

\item{tau}{For \code{biascorr = TRUE} only. The parameter of the power kernel.}

\item{covMat}{A Boolean variable. If \code{TRUE} (the default), the covariance matrix is calculated. Standard errors are obtained by taking the square root of the diagonal elements.}
}
\value{
For \code{WLS}, a list with the following components:
\tabular{ll}{
\code{theta} \tab The estimator with weight matrix identity. \cr
\code{covMatrix} \tab The estimated covariance matrix for the estimator. \cr
\code{value} \tab The value of the minimized function at \code{theta}. \cr
}
}
\description{
Estimation the parameter of the Gumbel model, using either the pairwise M-estimator or weighted least squares (WLS).
}
\details{
The matrix \code{indices} can be either user defined or returned by \code{selectGrid}. For \code{method = "Mestimator"}, only a grid with exactly two ones per row is accepted, representing the pairs to be used.
}
\examples{
## Generate data with theta = 0.5
set.seed(1)
n <- 1000
cop <- copula::gumbelCopula(param = 2, dim = 3)
data <- copula::rCopula(n = n,copula = cop)
## Transform data to unit Pareto margins
x <- apply(data, 2, function(i) n/(n + 0.5 - rank(i)))
## Define indices in which we evaluate the estimator
indices <- selectGrid(c(0,1), d = 3)
EstimationGumbel(x, indices, k = 50, method = "WLS", biascorr = TRUE)
}
\references{
Einmahl, J.H.J., Kiriliouk, A., and Segers, J. (2018). A continuous updating weighted least squares estimator of tail dependence in high dimensions. Extremes 21(2), 205-233.

Einmahl, J.H.J., Kiriliouk, A., Krajina, A., and Segers, J. (2016). An Mestimator of spatial tail dependence. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 78(1), 275-298.
}
\seealso{
\code{\link{selectGrid}}
}
