% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superlearner.R
\name{superlearner}
\alias{superlearner}
\alias{metalearner_nnls}
\title{Superlearner (stacked/ensemble learner)}
\usage{
superlearner(
  learners,
  data,
  nfolds = 10,
  meta.learner = metalearner_nnls,
  model.score = mse,
  mc.cores = NULL,
  future.seed = TRUE,
  silent = TRUE,
  name.prefix = NULL,
  ...
)
}
\arguments{
\item{learners}{(list) List of \link{learner} objects (i.e. \link{learner_glm})}

\item{data}{(data.frame) Data containing the response variable and
covariates.}

\item{nfolds}{(integer) Number of folds to use in cross-validation to
estimate the ensemble weights.}

\item{meta.learner}{(function) Algorithm to learn the ensemble weights
(default non-negative least squares). Must be a function of the response
(nx1 vector), \code{y}, and the predictions (nxp matrix), \code{pred}, with p being
the number of learners. Alternatively, this can be set to the character
value "discrete", in which case the Discrete Super-Learner is applied where
the model with the lowest risk (model-score) is given weight 1 and all
other learners weight 0.}

\item{model.score}{(function) Model scoring method (see \link{learner})}

\item{mc.cores}{(integer) If not NULL, then \link[parallel:mclapply]{parallel::mcmapply} is used with
\code{mc.cores} number of cores for parallelization instead of the
\link[future.apply:future_lapply]{future.apply::future_lapply} package. Parallelization is disabled with
\code{mc.cores = 1}.}

\item{future.seed}{(logical or integer) Argument passed on to
\link[future.apply:future_lapply]{future.apply::future_lapply}. If TRUE, then \link{.Random.seed} is used if it
holds a L'Ecuyer-CMRG RNG seed, otherwise one is created randomly.}

\item{silent}{(logical) Suppress all messages and progressbars}

\item{name.prefix}{(character) Prefix used to name learner objects in
\code{learners} without names. If NULL, then obtain the name from the info field
of a learner.}

\item{...}{Additional arguments to \link[parallel:mclapply]{parallel::mclapply} or
\link[future.apply:future_lapply]{future.apply::future_lapply}.}
}
\description{
This function creates a predictor object (class \link{learner}) from
a list of existing \link{learner} objects. When estimating this model a stacked
prediction will be created by weighting together the predictions of each of
the initial learners The weights are learned using cross-validation.
}
\examples{
sim1 <- function(n = 5e2) {
   x1 <- rnorm(n, sd = 2)
   x2 <- rnorm(n)
   y <- x1 + cos(x1) + rnorm(n, sd = 0.5**.5)
   data.frame(y, x1, x2)
}
m <- list(
  "mean" = learner_glm(y ~ 1),
  "glm" = learner_glm(y ~ x1 + x2)
)
sl <- superlearner(m, data = sim1(), nfolds = 2)
predict(sl, newdata = sim1(n = 5))
predict(sl, newdata = sim1(n = 5), all.learners = TRUE)
}
\references{
Luedtke & van der Laan (2016) Super-Learning of an Optimal
Dynamic Treatment Rule, The International Journal of Biostatistics.
}
\seealso{
\link{predict.superlearner} \link{weights.superlearner} \link{score.superlearner}
}
