% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\title{Render \code{teal_card}}
\usage{
render(
  input,
  output_dir = getwd(),
  global_knitr = getOption("teal.reporter.global_knitr"),
  keep_rmd = TRUE,
  ...
)
}
\arguments{
\item{input}{(\code{teal_report} or \code{teal_code}) object to render.}

\item{output_dir}{The output directory for the rendered \code{output_file}.
This allows for a choice of an alternate directory to which the output file
should be written (the default output directory of that of the input file).
If a path is provided with a filename in \code{output_file} the directory
specified here will take precedence. Please note that any directory path
provided will create any necessary directories if they do not exist.}

\item{global_knitr}{(\code{list}) options to apply to every code chunk in a teal_card document.
\href{https://rmarkdown.rstudio.com/lesson-3.html#global-options}{Read more here}.}

\item{keep_rmd}{(\code{logical(1)}) if \code{.Rmd} should be kept after rendering to desired \code{output_format}.}

\item{...}{arguments passed to \code{rmarkdown::render}.}
}
\description{
Render \code{teal_card}
}
\examples{
report <- teal_report()
teal_card(report) <- c(
  teal_card(report),
  "## Document section",
  "Lorem ipsum dolor sit amet"
)
report <- within(report, a <- 2)
report <- within(report, plot(a))
metadata(teal_card(report)) <- list(
  title = "My Document",
  author = "NEST"
)
if (interactive()) {
  render(report, output_format = rmarkdown::pdf_document(), global_knitr = list(fig.width = 10))
}
}
