% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{estimate-kappa}
\alias{estimate-kappa}
\alias{est.kappa.MLE}
\alias{est.kappa}
\title{Concentration parameter of von Mises distribution}
\usage{
est.kappa.MLE(x, w = NULL, bias = FALSE)

est.kappa(x, w = NULL, p = 2)
}
\arguments{
\item{x}{numeric. angles in degrees}

\item{w}{numeric. weightings}

\item{bias}{logical parameter determining whether a bias correction is used
in the computation of the MLE. Default for bias is \code{FALSE} for no bias
correction.}

\item{p}{integer. Number of parameters in the data space: 2 for circle (the default), 3 for a sphere.}
}
\value{
numeric. Concentration of a von Mises distribution
}
\description{
Estimates the concentration parameter of a von Mises distribution, given a
set of angular measurements.
}
\details{
\code{est.kappa.MLE()} is the maximum likelihood estimate for MLE for \eqn{\kappa}.

\code{est.kappa()} uses an approximation based on the empirical equation:
\deqn{\kappa =
    \frac{\bar{R}(p-\bar{R}^2)}{1-\bar{R}^2}
}
where \eqn{\bar{R}} is the mean resultant length and \eqn{p} is the
dimensionality of the data (2 for circular data).
}
\examples{
set.seed(123)
x <- rvm(100, 90, 10)
w <- weighting(runif(100, 0, 10))

est.kappa(x, w)

est.kappa.MLE(x, w)
}
