% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/various.R
\name{import_WSM}
\alias{import_WSM}
\alias{download_WSM}
\alias{load_WSM}
\alias{download_WSM2016}
\alias{load_WSM2016}
\title{World Stress Map Database (WSM)}
\source{
\url{https://datapub.gfz.de/download/10.5880.WSM.2025.001-Scbwez/WSM_Database_2025.csv}

\url{https://datapub.gfz-potsdam.de/download/10.5880.WSM.2016.001/wsm2016.csv}
}
\usage{
download_WSM(
  destdir = tempdir(),
  load = TRUE,
  version = c("2025", "2016"),
  ...
)

load_WSM(
  file,
  quality = c("A", "B", "C", "D", "E", "X"),
  lat_range = c(-90, 90),
  lon_range = c(-180, 180),
  depth_range = c(-Inf, Inf),
  type = c("BO", "BOC", "BOT", "BS", "DIF", "FMA", "FMF", "FMS", "GFI", "GFM", "GFS",
    "GVA", "HF", "HFG", "HFM", "HFH", "HFP", "HFS", "OC", "PC", "SWB", "SWL", "SWS"),
  regime = c("N", "NS", "T", "TS", "S", NA)
)

download_WSM2016(destdir = tempdir(), load = TRUE, ...)

load_WSM2016(
  file,
  quality = c("A", "B", "C", "D", "E"),
  lat_range = c(-90, 90),
  lon_range = c(-180, 180),
  depth_range = c(-Inf, Inf),
  type = c("BO", "BOC", "BOT", "BS", "DIF", "FMA", "FMF", "FMS", "GFI", "GFM", "GFS",
    "GVA", "HF", "HFG", "HFM", "HFP", "OC", "PC", "SWB", "SWL", "SWS"),
  regime = c("N", "NS", "T", "TS", "S", NA)
)
}
\arguments{
\item{destdir}{where to save files, defaults to \code{\link[base:tempfile]{base::tempdir()}},
\code{\link[base:getwd]{base::getwd()}} is also possible.}

\item{load}{\code{TRUE} load the dataset into R, \code{FALSE} return the
file name of the downloaded object.}

\item{version}{character. Version of the World stress map database. Either
\code{"2025"} (default) or \code{"2016"}}

\item{...}{(optional) arguments passed to \code{\link[=load_WSM]{load_WSM()}}}

\item{file}{the name of the file which the data are to be read from.}

\item{quality}{a character vectors containing the quality levels to be
included. Includes all quality ranks (A-X) by default.}

\item{lat_range, lon_range}{two-element numeric vectors giving the range of
latitudes and longitudes (in degrees).}

\item{depth_range}{two-element numeric vectors giving the depth interval
(in km)}

\item{type}{a character vectors containing the methods of stress inversion
to be included. Includes all methods by default. See WSM2016 manual for used
acronyms.}

\item{regime}{a character vectors containing the stress regimes to be
included. Acronyms: \code{"N"} - normal, \code{"T"} - thrust, \code{"S"} - strike-slip,
\code{"NS"} - oblique normal, \code{"TS"} - oblique thrust, and \code{NA} - unknown faulting}
}
\value{
\code{sf} object of and the parsed numeric uncertainty (\code{unc}) based on
the reported standard deviation and the quality rank. If \code{load=FALSE},
the path to the downloaded file is returned.
}
\description{
Download WSM2025 or WSM2016 database from the GFZ sever and applies optional filters.
If \code{destdir} is specified, the data can be reloaded in a later R session
using \code{load_WSM()} using the same arguments.
}
\note{
Because of R-compatibility and easy readability reasons, the downloaded
dataset is a modified version of the original, WSM server version:
All column names have been changed from uppercase (in the original dataset) to
lowercase characters.
Unknown azimuth values are represented by \code{NA} values instead of \code{999} in
the original.
Unknown regimes are represented by \code{NA} instead of "U" in the original.
}
\examples{
\dontrun{
download_WSM(
  quality = c("A", "B", "C"), lat_range = c(51, 72),
  lon_range = c(-180, -130), depth_range = c(0, 10), type = "FMS"
)
}
}
\references{
Heidbach, O., M. Rajabi, X. Cui, K. Fuchs, B. M<U+00FC>ller, J.
Reinecker, K. Reiter, M. Tingay, F. Wenzel, F. Xie, M. O. Ziegler,
M.-L. Zoback, and M. D. Zoback (2018): The World Stress Map database
release 2016: Crustal stress pattern across scales. \emph{Tectonophysics},
\strong{744}, 484-498, \doi{10.1016/j.tecto.2018.07.007}.

Heidbach, Oliver; Rajabi, Mojtaba; Di Giacomo, Domenico; Harris, James;
Lammers, Steffi; Morawietz, Sophia; Pierdominici, Simona; Reiter, Karsten;
von Specht, Sebastian; Storchak, Dmitry; Ziegler, Moritz O. (2025): World
Stress Map Database Release 2025. GFZ Data Services.
\doi{10.5880/WSM.2025.001}
}
\keyword{datasets}
