% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_2.R
\name{vt2_ctree}
\alias{vt2_ctree}
\title{Estimate the CATE using a conditional inference tree for Step 2}
\usage{
vt2_ctree(z, data, Trt, Y, theta)
}
\arguments{
\item{z}{a numeric vector of estimated CATEs from Step 1}

\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}

\item{theta}{the value of the test statistic that must be exceeded in order
to implement a split (\code{mincriterion})}
}
\value{
An object of class \code{BinaryTree-class}. See
\code{\link[party]{BinaryTree-class}}.
}
\description{
Estimate the CATE using a conditional inference tree for Step 2
}
\seealso{
Other VT Step 2 functions: 
\code{\link{vt2_classtree}()},
\code{\link{vt2_lasso}()},
\code{\link{vt2_rtree}()}
}
\concept{VT Step 2 functions}
