% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4h_second_filter.R
\name{filter_4h}
\alias{filter_4h}
\title{Basic Four Hit Filter for Detections}
\usage{
filter_4h(org_file, time_unit, multipath_time, org_ping_rate)
}
\arguments{
\item{org_file}{a dataframe of detections retrieved from `add_org()`}

\item{time_unit}{The unit of time used for analyses (secs, mins, hours,
days, weeks)}

\item{multipath_time}{A numeric maximum amount of time which must pass
between detections for a detection to be considered a "true", not a bounced,
signal.}

\item{org_ping_rate}{The expected time between transmissions emitted from
tags/transmitters implanted or attached to an organism}
}
\value{
A dataframe which has been filtered to remove false positives
}
\description{
This function takes a detection dataframe generated from the `add_org()`
function and filters it a second time to remove any remaining multipath
detections, and then check the remaining detections by comparing the time
between detections, for a rolling window of 4 detections to ensure it is less
16.6x the stated pulse rate interval. Called by `second_filter()`.
}
\examples{
# Apply a 4hit filter to data previously prefiltered and with organism data
filter_4h(org_file = dat_orgfilt,
          time_unit = "secs",
          multipath_time = 0.3,
          org_ping_rate = 3)
}
