% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{preprocess_text}
\alias{preprocess_text}
\title{Preprocess Text with Slang Handling}
\usage{
preprocess_text(text, use_textclean = TRUE, custom_slang = NULL)
}
\arguments{
\item{text}{A character vector of input texts.}

\item{use_textclean}{Logical. Whether to use \code{textclean} for internet slang and emoticon replacement. Default is \code{TRUE}.}

\item{custom_slang}{A named character vector providing user-defined slang mappings. Optional.}
}
\value{
A character vector of cleaned and normalized text.
}
\description{
This function performs multi-stage text preprocessing, including lowercasing,
HTML cleaning, punctuation normalization, contraction expansion, internet slang replacement,
emoticon replacement, and final standardization.
}
\details{
The preprocessing pipeline includes:
\itemize{
  \item Lowercasing the text.
  \item Replacing HTML entities and non-ASCII characters.
  \item Expanding common English contractions (e.g., "I'm" -> "I am").
  \item Replacing internet slang and emoticons if \code{use_textclean} is \code{TRUE}.
  \item Handling additional slang defined by the user.
  \item Normalizing repeated punctuations and whitespace.
}
}
\examples{
preprocess_text("I'm feeling lit rn!!!")
preprocess_text("I can't believe it... lol :)", use_textclean = TRUE)

}
