% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_transform}
\alias{img_transform}
\title{Transform}
\usage{
img_transform(
  images,
  transforms,
  interpolation = "NEAREST",
  output_shape = NULL,
  name = NULL
)
}
\arguments{
\item{images}{A tensor of shape (num_images, num_rows, num_columns, num_channels)
(NHWC), (num_rows, num_columns, num_channels) (HWC), or (num_rows, num_columns) (HW).}

\item{transforms}{Projective transform matrix/matrices. A vector of length 8 or tensor
of size N x 8. If one row of transforms is [a0, a1, a2, b0, b1, b2, c0, c1], then it
maps the output point (x, y) to a transformed input point
(x', y') = ((a0 x + a1 y + a2) / k, (b0 x + b1 y + b2) / k), where k = c0 x + c1 y + 1.
The transforms are inverted compared to the transform mapping input points to output points.
Note that gradients are not backpropagated into transformation parameters.}

\item{interpolation}{Interpolation mode. Supported values: "NEAREST", "BILINEAR".}

\item{output_shape}{Output dimesion after the transform, [height, width]. If NULL,
output is the same size as input image.}

\item{name}{The name of the op.}
}
\value{
Image(s) with the same type and shape as `images`, with
the given transform(s) applied. Transformed coordinates outside of the
input image will be filled with zeros.
}
\description{
Applies the given transform(s) to the image(s).
}
\section{Raises}{

TypeError: If `image` is an invalid type. ValueError: If output shape is not 1-D int32 Tensor.
}

\examples{

\dontrun{
transform = img_transform(img, c(1.0, 1.0, -250, 0.0, 1.0, 0.0, 0.0, 0.0))
}



}
