% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_gaussian_process}
\alias{tfd_gaussian_process}
\title{Marginal distribution of a Gaussian process at finitely many points.}
\usage{
tfd_gaussian_process(
  kernel,
  index_points,
  mean_fn = NULL,
  observation_noise_variance = 0,
  jitter = 1e-06,
  validate_args = FALSE,
  allow_nan_stats = FALSE,
  name = "GaussianProcess"
)
}
\arguments{
\item{kernel}{\code{PositiveSemidefiniteKernel}-like instance representing the
GP's covariance function.}

\item{index_points}{\code{float} \code{Tensor} representing finite (batch of) vector(s) of
points in the index set over which the GP is defined. Shape has the
form \verb{[b1, ..., bB, e1, f1, ..., fF]} where \code{F} is the number of feature
dimensions and must equal \code{kernel$feature_ndims} and \code{e1} is the number
(size) of index points in each batch (we denote it \code{e1} to distinguish
it from the numer of inducing index points, denoted \code{e2} below).
Ultimately the GaussianProcess distribution corresponds to an
\code{e1}-dimensional multivariate normal. The batch shape must be
broadcastable with \code{kernel$batch_shape}, the batch shape of
\code{inducing_index_points}, and any batch dims yielded by \code{mean_fn}.}

\item{mean_fn}{function that acts on index points to produce a (batch
of) vector(s) of mean values at those index points. Takes a \code{Tensor} of
shape \verb{[b1, ..., bB, f1, ..., fF]} and returns a \code{Tensor} whose shape is
(broadcastable with) \verb{[b1, ..., bB]}. Default value: \code{NULL} implies constant zero function.}

\item{observation_noise_variance}{\code{float} \code{Tensor} representing the variance
of the noise in the Normal likelihood distribution of the model. May be
batched, in which case the batch shape must be broadcastable with the
shapes of all other batched parameters (\code{kernel$batch_shape}, \code{index_points}, etc.).
Default value: \code{0.}}

\item{jitter}{\code{float} scalar \code{Tensor} added to the diagonal of the covariance
matrix to ensure positive definiteness of the covariance matrix. Default value: \code{1e-6}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
A Gaussian process (GP) is an indexed collection of random variables, any
finite collection of which are jointly Gaussian. While this definition applies
to finite index sets, it is typically implicit that the index set is infinite;
in applications, it is often some finite dimensional real or complex vector
space. In such cases, the GP may be thought of as a distribution over
(real- or complex-valued) functions defined over the index set.
}
\details{
Just as Gaussian distributions are fully specified by their first and second
moments, a Gaussian process can be completely specified by a mean and
covariance function.
Let \code{S} denote the index set and \code{K} the space in which
each indexed random variable takes its values (again, often R or C). The mean
function is then a map \code{m: S -> K}, and the covariance function, or kernel, is
a positive-definite function \verb{k: (S x S) -> K}. The properties of functions
drawn from a GP are entirely dictated (up to translation) by the form of the
kernel function.

This \code{Distribution} represents the marginal joint distribution over function
values at a given finite collection of points \verb{[x[1], ..., x[N]]} from the
index set \code{S}. By definition, this marginal distribution is just a
multivariate normal distribution, whose mean is given by the vector
\verb{[ m(x[1]), ..., m(x[N]) ]} and whose covariance matrix is constructed from
pairwise applications of the kernel function to the given inputs:

\if{html}{\out{<div class="sourceCode">}}\preformatted{| k(x[1], x[1])    k(x[1], x[2])  ...  k(x[1], x[N]) |
| k(x[2], x[1])    k(x[2], x[2])  ...  k(x[2], x[N]) |
|      ...              ...                 ...      |
| k(x[N], x[1])    k(x[N], x[2])  ...  k(x[N], x[N]) |
}\if{html}{\out{</div>}}

For this to be a valid covariance matrix, it must be symmetric and positive
definite; hence the requirement that \code{k} be a positive definite function
(which, by definition, says that the above procedure will yield PD matrices).

We also support the inclusion of zero-mean Gaussian noise in the model, via
the \code{observation_noise_variance} parameter. This augments the generative model
to

\if{html}{\out{<div class="sourceCode">}}\preformatted{f ~ GP(m, k)
(y[i] | f, x[i]) ~ Normal(f(x[i]), s)
}\if{html}{\out{</div>}}

where
\itemize{
\item \code{m} is the mean function
\item \code{k} is the covariance kernel function
\item \code{f} is the function drawn from the GP
\item \code{x[i]} are the index points at which the function is observed
\item \code{y[i]} are the observed values at the index points
\item \code{s} is the scale of the observation noise.
}

Note that this class represents an \emph{unconditional} Gaussian process; it does
not implement posterior inference conditional on observed function
evaluations. This class is useful, for example, if one wishes to combine a GP
prior with a non-conjugate likelihood using MCMC to sample from the posterior.

Mathematical Details

The probability density function (pdf) is a multivariate normal whose
parameters are derived from the GP's properties:

\if{html}{\out{<div class="sourceCode">}}\preformatted{pdf(x; index_points, mean_fn, kernel) = exp(-0.5 * y) / Z
K = (kernel.matrix(index_points, index_points) +
    (observation_noise_variance + jitter) * eye(N))
y = (x - mean_fn(index_points))^T @ K @ (x - mean_fn(index_points))
Z = (2 * pi)**(.5 * N) |det(K)|**(.5)
}\if{html}{\out{</div>}}

where:
\itemize{
\item \code{index_points} are points in the index set over which the GP is defined,
\item \code{mean_fn} is a callable mapping the index set to the GP's mean values,
\item \code{kernel} is \code{PositiveSemidefiniteKernel}-like and represents the covariance
function of the GP,
\item \code{observation_noise_variance} represents (optional) observation noise.
\item \code{jitter} is added to the diagonal to ensure positive definiteness up to
machine precision (otherwise Cholesky-decomposition is prone to failure),
\item \code{eye(N)} is an N-by-N identity matrix.
}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_independent}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
