% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dice.R
\name{roll_dice}
\alias{roll_dice}
\title{Simulating rolling a dice.}
\usage{
roll_dice(
  data = NULL,
  times = 1,
  rounds = 1,
  success = c(6),
  agg = FALSE,
  sides = 6,
  prob = NULL,
  seed = NULL
)
}
\arguments{
\item{data}{Data from a previous experiment}

\item{times}{How many times a dice is rolled (or how many dice are rolled at the same time)}

\item{rounds}{Number of rounds}

\item{success}{Which result is a success (default = 6)}

\item{agg}{If TRUE, the result is aggregated (by experiment, rounds)}

\item{sides}{Number of sides of the dice (default = 6)}

\item{prob}{Vector of probabilities for each side of the dice}

\item{seed}{Seed to produce reproducible results}
}
\value{
Result of experiment as a tibble
}
\description{
Rolling a dice is simulated using sample(). The default dice has 6 sides and is fair.
The properties of the dice can be changed.
The result is returned as a tibble.
}
\examples{
# rolling a dice once
roll_dice()

# rolling a dice 10 times
roll_dice(times = 10)

# aggregate result
roll_dice(times = 10, agg = TRUE)

# rounds 
roll_dice(times = 10, rounds = 3, agg = TRUE)

# experiments
library(dplyr)
roll_dice(times = 10, rounds = 3, agg = TRUE) \%>\% 
  roll_dice(times = 12, rounds = 3, agg = TRUE) 
}
