% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_groq.R
\name{groq}
\alias{groq}
\title{Groq API Provider Function}
\usage{
groq(..., .called_from = NULL)
}
\arguments{
\item{...}{Parameters to be passed to the Groq-specific function,
such as model configuration, input text, or API-specific options.}

\item{.called_from}{An internal argument that specifies which action (e.g.,
\code{chat}) the function is being invoked from.
This argument is automatically managed and should not be modified by the user.}
}
\value{
The result of the requested action, depending on the specific function invoked
(currently, only an updated \code{LLMMessage} object for \code{groq_chat()}).
}
\description{
The \code{groq()} function acts as an interface for interacting with the Groq API
through \code{tidyllm}'s main verbs. Currently, Groq only supports \code{groq_chat()}
for chat-based interactions and \code{groq_transcribe()} for transcription tasks.
}
\details{
Since \code{groq_transcribe()} is unique to Groq and does not have a general verb counterpart,
\code{groq()} currently routes messages only to \code{groq_chat()} when used with verbs like \code{chat()}.
}
