% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite-str.R
\name{unite_str}
\alias{unite_str}
\title{Unite multiple character columns into one}
\usage{
unite_str(data, col, ..., sep = ". ", remove = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{col}{The name of the new column, as a string or symbol.

This argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:defusing-advanced]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to unite}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}
}
\value{
The original data frame with the one or more columns combined as
character vectors separated by a period.
}
\description{
Convenience function for combining character columns.
}
\details{
Blank values of "" are converted into missing values.
}
\examples{
data <- tibble::tibble(x = c("good", "Saw fish.", "", NA), y = c("2021", NA, NA, NA))

# unite has poor handling of character vectors
tidyr::unite(data, "new", x, y, remove = FALSE)

unite_str(data, "new", x, y, remove = FALSE)
}
\seealso{
\code{\link[tidyr:unite]{tidyr::unite()}} and \code{\link[=collapse_comments]{collapse_comments()}}
}
