% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_spec_boost_tree.R
\name{sdm_spec_boost_tree}
\alias{sdm_spec_boost_tree}
\title{Model specification for a Boosted Trees model for SDM}
\usage{
sdm_spec_boost_tree(..., tune = c("sdm", "all", "custom", "none"))
}
\arguments{
\item{...}{parameters to be passed to \code{\link[parsnip:boost_tree]{parsnip::boost_tree()}} to customise
the model. See the help of that function for details.}

\item{tune}{character defining the tuning strategy. Valid strategies are:
\itemize{
\item "sdm" chooses hyperparameters that are most important to tune for
an sdm (for \emph{boost_tree}: 'mtry', 'trees', 'tree_depth', 'learn_rate',
'loss_reduction', and 'stop_iter')
\item "all" tunes all hyperparameters (for \emph{boost_tree}: 'mtry', 'trees',
'tree_depth', 'learn_rate', 'loss_reduction', 'stop_iter','min_n' and
'sample_size')
\item "custom" passes the options from '...'
\item "none" does not tune any hyperparameter
}}
}
\value{
a \link[parsnip:model_spec]{parsnip::model_spec} of the model.
}
\description{
This function returns a \link[parsnip:model_spec]{parsnip::model_spec} for a Boosted Trees model to be
used as a classifier of presences and absences in Species Distribution Model.
It uses the library \code{xgboost} to fit boosted trees; to use another library,
simply build the \link[parsnip:model_spec]{parsnip::model_spec} directly.
}
\examples{
\dontshow{if (rlang::is_installed("xgboost")) withAutoprint(\{ # examplesIf}
standard_bt_spec <- sdm_spec_boost_tree()
full_bt_spec <- sdm_spec_boost_tree(tune = "all")
custom_bt_spec <- sdm_spec_boost_tree(tune = "custom", mtry = tune::tune())
\dontshow{\}) # examplesIf}
}
\seealso{
Other "sdm model specifications": 
\code{\link{sdm_spec_gam}()},
\code{\link{sdm_spec_glm}()},
\code{\link{sdm_spec_maxent}()},
\code{\link{sdm_spec_rand_forest}()}
}
\concept{"sdm model specifications"}
