% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{grass_db}
\alias{grass_db}
\title{GRASS color tables}
\format{
A tibble of 2920 rows and 6 columns. with
the following fields:

\describe{
\item{pal}{ Name of the palette.}
\item{limit}{(Optional) limit for each color.}
\item{r}{Value of the red channel (RGB color mode).}
\item{g}{Value of the green channel (RGB color mode).}
\item{b}{Value of the blue channel (RGB color mode).}
\item{hex}{ Hex code of the color.}
}
}
\source{
Derived from \url{https://github.com/OSGeo/grass/tree/main/lib/gis/colors}. See
also \href{https://grass.osgeo.org/grass83/manuals/r.colors.html}{r.color - GRASS GIS Manual}.
}
\description{
A \link[tibble:tbl_df-class]{tibble} including the color map of
51 gradient palettes. Some palettes includes
also a definition of colors limits that can be used with
\code{\link[ggplot2:scale_gradient]{ggplot2::scale_fill_gradientn()}}.
}
\details{
Summary of palettes provided, description and recommended use:\tabular{llll}{
   \strong{palette} \tab \strong{use} \tab \strong{description} \tab \strong{range} \cr
   \code{aspect} \tab General \tab aspect oriented grey colors \tab  \cr
   \code{aspectcolr} \tab General \tab aspect oriented rainbow colors \tab 0 to 360 \cr
   \code{bcyr} \tab General \tab blue through cyan through yellow to red \tab  \cr
   \code{bgyr} \tab General \tab blue through green through yellow to red \tab  \cr
   \code{blues} \tab General \tab white to blue \tab  \cr
   \code{byg} \tab General \tab blue through yellow to green \tab  \cr
   \code{byr} \tab General \tab blue through yellow to red \tab  \cr
   \code{celsius} \tab General \tab blue to red for degree Celsius temperature \tab -80 to 80 \cr
   \code{corine} \tab Land Cover \tab EU Corine land cover colors \tab 111 to 995 \cr
   \code{curvature} \tab General \tab for terrain curvatures \tab -0.1 to 0.1 \cr
   \code{differences} \tab General \tab differences oriented colors \tab  \cr
   \code{elevation} \tab Topography \tab maps relative ranges of raster values to elevation color ramp \tab  \cr
   \code{etopo2} \tab Topography \tab colors for ETOPO2 worldwide bathymetry/topography \tab -11000 to 8850 \cr
   \code{evi} \tab Natural \tab enhanced vegetative index colors \tab -1 to 1 \cr
   \code{fahrenheit} \tab Temperature \tab blue to red for Fahrenheit temperature \tab -112 to 176 \cr
   \code{forest_cover} \tab Natural \tab percentage of forest cover \tab 0 to 1 \cr
   \code{gdd} \tab Natural \tab accumulated growing degree days \tab 0 to 6000 \cr
   \code{grass} \tab General \tab GRASS GIS green (perceptually uniform) \tab  \cr
   \code{greens} \tab General \tab white to green \tab  \cr
   \code{grey} \tab General \tab grey scale \tab  \cr
   \code{gyr} \tab General \tab green through yellow to red \tab  \cr
   \code{haxby} \tab Topography \tab relative colors for bathymetry or topography \tab  \cr
   \code{inferno} \tab General \tab perceptually uniform sequential color table inferno \tab  \cr
   \code{kelvin} \tab Temperature \tab blue to red for temperature in Kelvin scale \tab 193.15 to 353.15 \cr
   \code{magma} \tab General \tab perceptually uniform sequential color table magma \tab  \cr
   \code{ndvi} \tab Natural \tab Normalized Difference Vegetation Index colors \tab -1 to 1 \cr
   \code{ndwi} \tab Natural \tab Normalized Difference Water Index colors \tab -200 to 200 \cr
   \code{nlcd} \tab Land Cover \tab US National Land Cover Dataset colors \tab 0 to 95 \cr
   \code{oranges} \tab General \tab white to orange \tab  \cr
   \code{plasma} \tab General \tab perceptually uniform sequential color table plasma \tab  \cr
   \code{population} \tab Human \tab color table covering human population classification breaks \tab 0 to 1000000 \cr
   \code{population_dens} \tab Human \tab color table covering human population density classification breaks \tab 0 to 1000 \cr
   \code{precipitation} \tab Climate \tab precipitation color table (0..2000mm) \tab 0 to 7000 \cr
   \code{precipitation_daily} \tab Climate \tab precipitation color table (0..1000mm) \tab 0 to 100 \cr
   \code{precipitation_monthly} \tab Climate \tab precipitation color table (0..1000mm) \tab 0 to 1000 \cr
   \code{rainbow} \tab General \tab rainbow color table \tab  \cr
   \code{ramp} \tab General \tab color ramp \tab  \cr
   \code{reds} \tab General \tab white to red \tab  \cr
   \code{roygbiv} \tab General \tab  \tab  \cr
   \code{rstcurv} \tab General \tab terrain curvature (from r.resamp.rst) \tab -0.1 to 0.1 \cr
   \code{ryb} \tab General \tab red through yellow to blue \tab  \cr
   \code{ryg} \tab General \tab red through yellow to green \tab  \cr
   \code{sepia} \tab General \tab yellowish-brown through to white \tab  \cr
   \code{slope} \tab General \tab r.slope.aspect-type slope colors for raster values 0-90 \tab 0 to 90 \cr
   \code{soilmoisture} \tab Natural \tab soil moisture color table (0.0-1.0) \tab 0 to 1 \cr
   \code{srtm} \tab Topography \tab color palette for Shuttle Radar Topography Mission elevation \tab -11000 to 8850 \cr
   \code{srtm_plus} \tab Topography \tab color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) \tab -11000 to 8850 \cr
   \code{terrain} \tab Topography \tab global elevation color table covering -11000 to +8850m \tab -11000 to 8850 \cr
   \code{viridis} \tab General \tab perceptually uniform sequential color table viridis \tab  \cr
   \code{water} \tab Natural \tab water depth \tab  \cr
   \code{wave} \tab General \tab color wave \tab  \cr
}
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:mappal]{terra::map.pal()}}
}

\examples{
\donttest{
data("grass_db")

grass_db
# Select a palette

srtm_plus <- grass_db |>
  filter(pal == "srtm_plus")

f <- system.file("extdata/asia.tif", package = "tidyterra")
r <- terra::rast(f)

library(ggplot2)

p <- ggplot() +
  geom_spatraster(data = r) +
  labs(fill = "elevation")

p +
  scale_fill_gradientn(colors = srtm_plus$hex)

# Use with limits
p +
  scale_fill_gradientn(
    colors = srtm_plus$hex,
    values = scales::rescale(srtm_plus$limit),
    limit = range(srtm_plus$limit),
    na.value = "lightblue"
  )
}
}
\references{
GRASS Development Team (2024). \emph{Geographic Resources Analysis Support System
(GRASS) Software, Version 8.3.2}. Open Source Geospatial Foundation, USA.
\url{https://grass.osgeo.org}.
}
\seealso{
\code{\link[=scale_fill_grass_c]{scale_fill_grass_c()}}

Other datasets: 
\code{\link{cross_blended_hypsometric_tints_db}},
\code{\link{hypsometric_tints_db}},
\code{\link{princess_db}},
\code{\link{volcano2}}
}
\concept{datasets}
