% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{db_dataset_update_metadata}
\alias{db_dataset_update_metadata}
\title{Update Description and/or Metadata of a Dataset}
\usage{
db_dataset_update_metadata(
  con,
  set_name,
  description = NULL,
  metadata = NULL,
  metadata_update_mode = "update",
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{set_name}{\strong{character} name of a dataset.}

\item{description}{character New description. If set to NA (default) the description is left untouched}

\item{metadata}{\strong{list} Metadata update (see metadata_update_mode)}

\item{metadata_update_mode}{character one of "update" or "overwrite". If set to "update",
new fields in the list are added to the existing metadata and existing fields overwritten.
If NA nothing happens in update mode. If set to "overwrite" ALL existing metadata is replaced.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Update Description and/or Metadata of a Dataset
}
\examples{

\dontrun{

db_dataset_update_metadata(
  con = connection,
  set_name = "zrh_airport_data",
  description = "updating description Zurich airport arrivals and departures",
  schema = "schema"
)
}
}
\seealso{
Other datasets functions: 
\code{\link{db_dataset_create}()},
\code{\link{db_dataset_delete}()},
\code{\link{db_dataset_get_keys}()},
\code{\link{db_dataset_get_last_update}()},
\code{\link{db_dataset_list}()},
\code{\link{db_dataset_trim_history}()},
\code{\link{db_ts_assign_dataset}()},
\code{\link{db_ts_get_dataset}()}
}
\concept{datasets functions}
