% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-scales.R
\name{axis_t}
\alias{axis_t}
\title{Compute Time Axis Parameters for Plotting}
\usage{
axis_t(
  x,
  limits = NULL,
  format = NULL,
  locale = NULL,
  expand = FALSE,
  n.breaks = 5L
)
}
\arguments{
\item{x}{time indices for which an axis is to be created.}

\item{limits}{\code{NULL} for automatic limits, \code{tinterval} of length 1
or \code{tind} of length 2.}

\item{format}{(optional) a character string determining label format
(see \code{\link{format}}) or a custom formatting function.}

\item{locale}{(optional) a character string determining locale to be used
for formatting labels, see \link{calendar-names} for information
on locale settings.}

\item{expand}{a logical value. If \code{TRUE}, limits are expanded by 3\%
on both sides.}

\item{n.breaks}{an integer value, desired number of breaks.}
}
\value{
A six-element list with scale limits (\code{lim}), vector of tick-mark
positions (\code{at}), character vector with tick-mark labels (\code{labels}),
vector of minor tick-mark positions (\code{minor}), resolution (in Cartesian
coordinates) of time indices (\code{resolution}), and \code{limits} argument
converted to a \code{tinterval} of the same index type as \code{x} (\code{limits}).
}
\description{
Auxiliary function \code{axis_t} returns a six-element list with axis
limits (in Cartesian coordinates), tick-mark positions (in Cartesian
coordinates), tick-mark labels (character vector), positioning of minor
tick-marks (in Cartesian coordinates), resolution of indices (in Cartesian
coordinates), and \code{limits} argument converted to a \code{tinterval}
of the same index type as \code{x}. The results can be used for manual creation
of axes in plots.
}
\examples{
\donttest{
# load graphics
library(graphics)
# artificial data
N <- 180
df <- data.frame(d = today() + (-N + 1):0, y = cumsum(rnorm(N)))
(axt <- axis_t(df$d, format = "\%m/\%d/\%y", n.breaks = 6L))
# custom time axis with minor breaks
plot(df$d, df$y, xlim = axt$lim, type = "l", xaxt = "n", xaxs = "i")
axis(1, at = axt$lim, labels = FALSE, lwd = 1, lwd.ticks = 0)
axis(1, at = axt$at, labels = axt$labels, lwd = 0, lwd.ticks = .7)
axis(1, at = axt$minor, labels = FALSE, lwd = 0, lwd.ticks = .4)
}

}
\seealso{
\code{\link{pretty}} for computing pretty breakpoints,
\code{\link{axis.tind}} for creating axes with \pkg{graphics} package,
\code{\link{scale_tind}} for creating axes with \pkg{ggplot2}.
}
