% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTestDir.R
\name{formattedFrame}
\alias{formattedFrame}
\title{Help function to generate the formatted string for a single stack frame.}
\usage{
formattedFrame(framecall, frameN, hasSrcInfo, dirName, fileName, lineNr)
}
\arguments{
\item{framecall}{\code{character(n)}: deparsed call for the given stack. Each element corresponds to
a line.}

\item{frameN}{\code{integer(1)}: frame nummer.}

\item{hasSrcInfo}{\code{logical(1)}: Does the call have any source info?}

\item{dirName}{\code{character(1)}: the directory name of the source file.}

\item{fileName}{\code{character(1)}: filename of the source. Value ignored if hasSrcInfo=TRUE.}

\item{lineNr}{\code{character(1)}: linenr in the source where the call occured..
Value ignored if hasSrcInfo=TRUE.}
}
\value{
\code{characer(1)} the formatted character string containing info of a single frame in the
stackstrace
}
\description{
Help function to generate the formatted string for a single stack frame.
}
\details{
For a given frame in the stack the string is formatted as follows (substitute the arguments
between the curly braces)
\code{
{frameN}| {call[1]}
{frameN}| {call[2]}
{frameN}| {call[3]}
{frameN}| {call[3]}
---> at File={dirName/fileName} Line={line}:
}

For example for only a single line error:
\code{
1: stop("This is a crash")
---> at File=R/my_r_code_file.R Line=234
}

Currently all call lines are printed for a given stack.
The last line with source file info only printed if hasSrcInfo=TRUE. Else it is ommited.
}
